/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update.processor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.SolrCore;
import org.apache.solr.update.processor.FieldMutatingUpdateProcessor;
import org.apache.solr.update.processor.FieldValueSubsetUpdateProcessorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UniqFieldsUpdateProcessorFactory
extends FieldValueSubsetUpdateProcessorFactory {
    public static final Logger log = LoggerFactory.getLogger(UniqFieldsUpdateProcessorFactory.class);

    @Override
    public FieldMutatingUpdateProcessor.FieldNameSelector getDefaultSelector(SolrCore core) {
        return FieldMutatingUpdateProcessor.SELECT_NO_FIELDS;
    }

    @Override
    public void init(NamedList args) {
        NamedList flst = (NamedList)args.remove("fields");
        if (flst != null) {
            log.warn("Use of the 'fields' init param in UniqFieldsUpdateProcessorFactory is deprecated, please use 'fieldName' (or another FieldMutatingUpdateProcessorFactory selector option) instead");
            log.info("Replacing 'fields' init param with (individual) 'fieldName' params");
            for (Map.Entry entry : flst) {
                args.add("fieldName", entry.getValue());
            }
        }
        super.init(args);
    }

    public Collection pickSubset(Collection values) {
        HashSet uniqs = new HashSet();
        ArrayList result = new ArrayList(values.size());
        for (Object o : values) {
            if (uniqs.contains(o)) continue;
            uniqs.add(o);
            result.add(o);
        }
        return result;
    }
}

