/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.io.IOException;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.search.SortField;
import org.apache.solr.response.TextResponseWriter;
import org.apache.solr.schema.PrimitiveFieldType;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.QParser;
import org.apache.solr.util.BCDUtils;

public class BCDIntField
extends PrimitiveFieldType {
    @Override
    public SortField getSortField(SchemaField field, boolean reverse) {
        return this.getStringSort(field, reverse);
    }

    @Override
    public ValueSource getValueSource(SchemaField field, QParser qparser) {
        throw new UnsupportedOperationException("ValueSource not implemented");
    }

    @Override
    public String toInternal(String val) {
        return BCDUtils.base10toBase10kSortableInt(val);
    }

    @Override
    public String toExternal(IndexableField f) {
        return this.indexedToReadable(f.stringValue());
    }

    @Override
    public Object toObject(IndexableField f) {
        return Integer.valueOf(this.toExternal(f));
    }

    @Override
    public String indexedToReadable(String indexedForm) {
        return BCDUtils.base10kSortableIntToBase10(indexedForm);
    }

    @Override
    public void write(TextResponseWriter writer, String name, IndexableField f) throws IOException {
        writer.writeInt(name, this.toExternal(f));
    }

    @Override
    public Object marshalSortValue(Object value) {
        return BCDIntField.marshalStringSortValue(value);
    }

    @Override
    public Object unmarshalSortValue(Object value) {
        return BCDIntField.unmarshalStringSortValue(value);
    }
}

