/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.solr.osgi;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.oak.plugins.index.solr.configuration.OakSolrConfigurationProvider;
import org.apache.jackrabbit.oak.plugins.index.solr.query.SolrQueryIndexProvider;
import org.apache.jackrabbit.oak.plugins.index.solr.server.SolrServerProvider;
import org.apache.jackrabbit.oak.spi.query.QueryIndex;
import org.apache.jackrabbit.oak.spi.query.QueryIndexProvider;
import org.apache.jackrabbit.oak.spi.state.NodeState;

@Component(metatype=false, immediate=true)
@Service(value={QueryIndexProvider.class})
public class SolrQueryIndexProviderService
implements QueryIndexProvider {
    @Reference
    private SolrServerProvider solrServerProvider;
    @Reference
    private OakSolrConfigurationProvider oakSolrConfigurationProvider;

    @Nonnull
    public List<? extends QueryIndex> getQueryIndexes(NodeState nodeState) {
        if (this.solrServerProvider != null && this.oakSolrConfigurationProvider != null) {
            return new SolrQueryIndexProvider(this.solrServerProvider, this.oakSolrConfigurationProvider).getQueryIndexes(nodeState);
        }
        return new ArrayList();
    }

    protected void bindSolrServerProvider(SolrServerProvider solrServerProvider) {
        this.solrServerProvider = solrServerProvider;
    }

    protected void unbindSolrServerProvider(SolrServerProvider solrServerProvider) {
        if (this.solrServerProvider == solrServerProvider) {
            this.solrServerProvider = null;
        }
    }

    protected void bindOakSolrConfigurationProvider(OakSolrConfigurationProvider oakSolrConfigurationProvider) {
        this.oakSolrConfigurationProvider = oakSolrConfigurationProvider;
    }

    protected void unbindOakSolrConfigurationProvider(OakSolrConfigurationProvider oakSolrConfigurationProvider) {
        if (this.oakSolrConfigurationProvider == oakSolrConfigurationProvider) {
            this.oakSolrConfigurationProvider = null;
        }
    }
}

