/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update;

import java.io.IOException;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.List;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.HttpSolrServer;
import org.apache.solr.client.solrj.request.AbstractUpdateRequest;
import org.apache.solr.client.solrj.request.UpdateRequest;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ZkCoreNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.Diagnostics;
import org.apache.solr.update.AddUpdateCommand;
import org.apache.solr.update.CommitUpdateCommand;
import org.apache.solr.update.DeleteUpdateCommand;
import org.apache.solr.update.StreamingSolrServers;
import org.apache.solr.update.UpdateShardHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrCmdDistributor {
    private static final int MAX_RETRIES_ON_FORWARD = 25;
    public static Logger log = LoggerFactory.getLogger(SolrCmdDistributor.class);
    private StreamingSolrServers servers;
    private int retryPause = 500;
    private int maxRetriesOnForward = 25;
    private List<Error> allErrors = new ArrayList<Error>();
    private List<Error> errors = new ArrayList<Error>();
    public static Diagnostics.Callable testing_errorHook;

    public SolrCmdDistributor(UpdateShardHandler updateShardHandler) {
        this.servers = new StreamingSolrServers(updateShardHandler);
    }

    public SolrCmdDistributor(StreamingSolrServers servers, int maxRetriesOnForward, int retryPause) {
        this.servers = servers;
        this.maxRetriesOnForward = maxRetriesOnForward;
        this.retryPause = retryPause;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() {
        try {
            this.servers.blockUntilFinished();
            this.doRetriesIfNeeded();
        }
        finally {
            this.servers.shutdown();
        }
    }

    private void doRetriesIfNeeded() {
        ArrayList<Error> errors = new ArrayList<Error>(this.errors);
        errors.addAll(this.servers.getErrors());
        ArrayList<Error> resubmitList = new ArrayList<Error>();
        for (Error err : errors) {
            try {
                String oldNodeUrl = err.req.node.getUrl();
                boolean isRetry = err.req.node.checkRetry();
                boolean doRetry = false;
                int rspCode = err.statusCode;
                if (testing_errorHook != null) {
                    Diagnostics.call(testing_errorHook, err.e);
                }
                if (isRetry) {
                    if (rspCode == 404 || rspCode == 403 || rspCode == 503) {
                        doRetry = true;
                    }
                    if (err.e instanceof SolrServerException && ((SolrServerException)err.e).getRootCause() instanceof ConnectException) {
                        doRetry = true;
                    }
                    if (err.e instanceof ConnectException) {
                        doRetry = true;
                    }
                    if (err.req.retries < this.maxRetriesOnForward && doRetry) {
                        ++err.req.retries;
                        SolrException.log(log, "forwarding update to " + oldNodeUrl + " failed - retrying ... retries: " + err.req.retries + " " + err.req.cmdString + " params:" + err.req.uReq.getParams() + " rsp:" + rspCode, err.e);
                        try {
                            Thread.sleep(this.retryPause);
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            log.warn(null, (Throwable)e);
                        }
                        resubmitList.add(err);
                        continue;
                    }
                    this.allErrors.add(err);
                    continue;
                }
                this.allErrors.add(err);
            }
            catch (Exception e) {
                log.error("Unexpected Error while doing request retries", (Throwable)e);
            }
        }
        this.servers.clearErrors();
        this.errors.clear();
        for (Error err : resubmitList) {
            this.submit(err.req);
        }
        if (resubmitList.size() > 0) {
            this.servers.blockUntilFinished();
            this.doRetriesIfNeeded();
        }
    }

    public void distribDelete(DeleteUpdateCommand cmd, List<Node> nodes, ModifiableSolrParams params) throws IOException {
        this.distribDelete(cmd, nodes, params, false);
    }

    public void distribDelete(DeleteUpdateCommand cmd, List<Node> nodes, ModifiableSolrParams params, boolean sync) throws IOException {
        for (Node node : nodes) {
            UpdateRequest uReq = new UpdateRequest();
            uReq.setParams(params);
            if (cmd.isDeleteById()) {
                uReq.deleteById(cmd.getId(), cmd.getVersion());
            } else {
                uReq.deleteByQuery(cmd.query);
            }
            this.submit(new Req(cmd.toString(), node, uReq, sync));
        }
    }

    public void distribAdd(AddUpdateCommand cmd, List<Node> nodes, ModifiableSolrParams params) throws IOException {
        this.distribAdd(cmd, nodes, params, false);
    }

    public void distribAdd(AddUpdateCommand cmd, List<Node> nodes, ModifiableSolrParams params, boolean synchronous) throws IOException {
        for (Node node : nodes) {
            UpdateRequest uReq = new UpdateRequest();
            uReq.setParams(params);
            uReq.add(cmd.solrDoc, cmd.commitWithin, cmd.overwrite);
            this.submit(new Req(cmd.toString(), node, uReq, synchronous));
        }
    }

    public void distribCommit(CommitUpdateCommand cmd, List<Node> nodes, ModifiableSolrParams params) throws IOException {
        this.servers.blockUntilFinished();
        this.doRetriesIfNeeded();
        UpdateRequest uReq = new UpdateRequest();
        uReq.setParams(params);
        this.addCommit(uReq, cmd);
        log.debug("Distrib commit to: {} params: {}", nodes, (Object)params);
        for (Node node : nodes) {
            this.submit(new Req(cmd.toString(), node, uReq, false));
        }
    }

    void addCommit(UpdateRequest ureq, CommitUpdateCommand cmd) {
        if (cmd == null) {
            return;
        }
        ureq.setAction(cmd.optimize ? AbstractUpdateRequest.ACTION.OPTIMIZE : AbstractUpdateRequest.ACTION.COMMIT, false, cmd.waitSearcher, cmd.maxOptimizeSegments, cmd.softCommit, cmd.expungeDeletes);
    }

    private void submit(Req req) {
        if (req.synchronous) {
            this.servers.blockUntilFinished();
            this.doRetriesIfNeeded();
            HttpSolrServer server = new HttpSolrServer(req.node.getUrl(), this.servers.getHttpClient());
            try {
                server.request(req.uReq);
            }
            catch (Exception e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Failed synchronous update on shard " + req.node + " update: " + req.uReq, (Throwable)e);
            }
            finally {
                server.shutdown();
            }
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("sending update to " + req.node.getUrl() + " retry:" + req.retries + " " + req.cmdString + " params:" + req.uReq.getParams());
        }
        try {
            SolrServer solrServer = this.servers.getSolrServer(req);
            NamedList<Object> rsp = solrServer.request(req.uReq);
        }
        catch (Exception e) {
            SolrException.log(log, e);
            Error error = new Error();
            error.e = e;
            error.req = req;
            if (e instanceof SolrException) {
                error.statusCode = ((SolrException)e).code();
            }
            this.errors.add(error);
        }
    }

    public List<Error> getErrors() {
        return this.allErrors;
    }

    public static class RetryNode
    extends StdNode {
        private ZkStateReader zkStateReader;
        private String collection;
        private String shardId;

        public RetryNode(ZkCoreNodeProps nodeProps, ZkStateReader zkStateReader, String collection, String shardId) {
            super(nodeProps);
            this.zkStateReader = zkStateReader;
            this.collection = collection;
            this.shardId = shardId;
        }

        @Override
        public boolean checkRetry() {
            ZkCoreNodeProps leaderProps;
            try {
                leaderProps = new ZkCoreNodeProps(this.zkStateReader.getLeaderRetry(this.collection, this.shardId));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return false;
            }
            catch (Exception e) {
                log.warn(null, (Throwable)e);
                return true;
            }
            this.nodeProps = leaderProps;
            return true;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.collection == null ? 0 : this.collection.hashCode());
            result = 31 * result + (this.shardId == null ? 0 : this.shardId.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RetryNode other = (RetryNode)obj;
            return !(this.nodeProps.getCoreUrl() == null ? other.nodeProps.getCoreUrl() != null : !this.nodeProps.getCoreUrl().equals(other.nodeProps.getCoreUrl()));
        }
    }

    public static class StdNode
    extends Node {
        protected ZkCoreNodeProps nodeProps;

        public StdNode(ZkCoreNodeProps nodeProps) {
            this.nodeProps = nodeProps;
        }

        @Override
        public String getUrl() {
            return this.nodeProps.getCoreUrl();
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + this.nodeProps.getCoreUrl();
        }

        @Override
        public boolean checkRetry() {
            return false;
        }

        @Override
        public String getBaseUrl() {
            return this.nodeProps.getBaseUrl();
        }

        @Override
        public String getCoreName() {
            return this.nodeProps.getCoreName();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            String baseUrl = this.nodeProps.getBaseUrl();
            String coreName = this.nodeProps.getCoreName();
            String url = this.nodeProps.getCoreUrl();
            result = 31 * result + (baseUrl == null ? 0 : baseUrl.hashCode());
            result = 31 * result + (coreName == null ? 0 : coreName.hashCode());
            result = 31 * result + (url == null ? 0 : url.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            StdNode other = (StdNode)obj;
            String baseUrl = this.nodeProps.getBaseUrl();
            String coreName = this.nodeProps.getCoreName();
            String url = this.nodeProps.getCoreUrl();
            if (baseUrl == null ? other.nodeProps.getBaseUrl() != null : !baseUrl.equals(other.nodeProps.getBaseUrl())) {
                return false;
            }
            if (coreName == null ? other.nodeProps.getCoreName() != null : !coreName.equals(other.nodeProps.getCoreName())) {
                return false;
            }
            return !(url == null ? other.nodeProps.getCoreUrl() != null : !url.equals(other.nodeProps.getCoreUrl()));
        }

        @Override
        public ZkCoreNodeProps getNodeProps() {
            return this.nodeProps;
        }
    }

    public static abstract class Node {
        public abstract String getUrl();

        public abstract boolean checkRetry();

        public abstract String getCoreName();

        public abstract String getBaseUrl();

        public abstract ZkCoreNodeProps getNodeProps();
    }

    public static class Error {
        public Exception e;
        public int statusCode = -1;
        public Req req;
    }

    public static class Response {
        public List<Error> errors = new ArrayList<Error>();
    }

    public static class Req {
        public Node node;
        public UpdateRequest uReq;
        public int retries;
        public boolean synchronous;
        public String cmdString;

        public Req(String cmdString, Node node, UpdateRequest uReq, boolean synchronous) {
            this.node = node;
            this.uReq = uReq;
            this.synchronous = synchronous;
            this.cmdString = cmdString;
        }
    }

    public static interface AbortCheck {
        public boolean abortCheck();
    }
}

