/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.TermToBytesRefAttribute;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CharsRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.QueryBuilder;
import org.apache.lucene.util.UnicodeUtil;
import org.apache.solr.common.SolrException;
import org.apache.solr.response.TextResponseWriter;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.QParser;

public class TextField
extends FieldType {
    protected boolean autoGeneratePhraseQueries;
    protected Analyzer multiTermAnalyzer = null;
    private boolean isExplicitMultiTermAnalyzer = false;

    @Override
    protected void init(IndexSchema schema, Map<String, String> args) {
        this.properties |= 2;
        if (schema.getVersion() > 1.1f && 0 == (this.trueProperties & 0x20)) {
            this.properties &= 0xFFFFFFDF;
        }
        this.autoGeneratePhraseQueries = !(schema.getVersion() > 1.3f);
        String autoGeneratePhraseQueriesStr = args.remove("autoGeneratePhraseQueries");
        if (autoGeneratePhraseQueriesStr != null) {
            this.autoGeneratePhraseQueries = Boolean.parseBoolean(autoGeneratePhraseQueriesStr);
        }
        super.init(schema, args);
    }

    public Analyzer getMultiTermAnalyzer() {
        return this.multiTermAnalyzer;
    }

    public void setMultiTermAnalyzer(Analyzer analyzer) {
        this.multiTermAnalyzer = analyzer;
    }

    public boolean getAutoGeneratePhraseQueries() {
        return this.autoGeneratePhraseQueries;
    }

    @Override
    public SortField getSortField(SchemaField field, boolean reverse) {
        return this.getStringSort(field, reverse);
    }

    @Override
    public void write(TextResponseWriter writer, String name, IndexableField f) throws IOException {
        writer.writeStr(name, f.stringValue(), true);
    }

    @Override
    public Query getFieldQuery(QParser parser, SchemaField field, String externalVal) {
        return TextField.parseFieldQuery(parser, this.getQueryAnalyzer(), field.getName(), externalVal);
    }

    @Override
    public Object toObject(SchemaField sf, BytesRef term) {
        return term.utf8ToString();
    }

    @Override
    public void setAnalyzer(Analyzer analyzer) {
        this.analyzer = analyzer;
    }

    @Override
    public void setQueryAnalyzer(Analyzer analyzer) {
        this.queryAnalyzer = analyzer;
    }

    @Override
    public Query getRangeQuery(QParser parser, SchemaField field, String part1, String part2, boolean minInclusive, boolean maxInclusive) {
        Analyzer multiAnalyzer = this.getMultiTermAnalyzer();
        BytesRef lower = TextField.analyzeMultiTerm(field.getName(), part1, multiAnalyzer);
        BytesRef upper = TextField.analyzeMultiTerm(field.getName(), part2, multiAnalyzer);
        return new TermRangeQuery(field.getName(), lower, upper, minInclusive, maxInclusive);
    }

    public static BytesRef analyzeMultiTerm(String field, String part, Analyzer analyzerIn) {
        BytesRef bytesRef;
        if (part == null || analyzerIn == null) {
            return null;
        }
        TokenStream source = null;
        try {
            source = analyzerIn.tokenStream(field, part);
            source.reset();
            TermToBytesRefAttribute termAtt = source.getAttribute(TermToBytesRefAttribute.class);
            BytesRef bytes = termAtt.getBytesRef();
            if (!source.incrementToken()) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "analyzer returned no terms for multiTerm term: " + part);
            }
            termAtt.fillBytesRef();
            if (source.incrementToken()) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "analyzer returned too many terms for multiTerm term: " + part);
            }
            source.end();
            bytesRef = BytesRef.deepCopyOf(bytes);
        }
        catch (IOException e) {
            try {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "error analyzing range part: " + part, (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeWhileHandlingException(source);
                throw throwable;
            }
        }
        IOUtils.closeWhileHandlingException(source);
        return bytesRef;
    }

    static Query parseFieldQuery(QParser parser, Analyzer analyzer, String field, String queryText) {
        return new QueryBuilder(analyzer).createPhraseQuery(field, queryText);
    }

    public void setIsExplicitMultiTermAnalyzer(boolean isExplicitMultiTermAnalyzer) {
        this.isExplicitMultiTermAnalyzer = isExplicitMultiTermAnalyzer;
    }

    public boolean isExplicitMultiTermAnalyzer() {
        return this.isExplicitMultiTermAnalyzer;
    }

    @Override
    public Object marshalSortValue(Object value) {
        if (null == value) {
            return null;
        }
        CharsRef spare = new CharsRef();
        UnicodeUtil.UTF8toUTF16((BytesRef)value, spare);
        return spare.toString();
    }

    @Override
    public Object unmarshalSortValue(Object value) {
        if (null == value) {
            return null;
        }
        BytesRef spare = new BytesRef();
        String stringVal = (String)value;
        UnicodeUtil.UTF16toUTF8(stringVal, 0, stringVal.length(), spare);
        return spare;
    }
}

