/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.prefix;

import com.spatial4j.core.shape.Shape;
import java.io.IOException;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.DocsEnum;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.Filter;
import org.apache.lucene.spatial.prefix.tree.SpatialPrefixTree;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.FixedBitSet;

public abstract class AbstractPrefixTreeFilter
extends Filter {
    protected final Shape queryShape;
    protected final String fieldName;
    protected final SpatialPrefixTree grid;
    protected final int detailLevel;

    public AbstractPrefixTreeFilter(Shape queryShape, String fieldName, SpatialPrefixTree grid, int detailLevel) {
        this.queryShape = queryShape;
        this.fieldName = fieldName;
        this.grid = grid;
        this.detailLevel = detailLevel;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!this.getClass().equals(o.getClass())) {
            return false;
        }
        AbstractPrefixTreeFilter that = (AbstractPrefixTreeFilter)o;
        if (this.detailLevel != that.detailLevel) {
            return false;
        }
        if (!this.fieldName.equals(that.fieldName)) {
            return false;
        }
        return this.queryShape.equals(that.queryShape);
    }

    public int hashCode() {
        int result = this.queryShape.hashCode();
        result = 31 * result + this.fieldName.hashCode();
        result = 31 * result + this.detailLevel;
        return result;
    }

    public abstract class BaseTermsEnumTraverser {
        protected final AtomicReaderContext context;
        protected Bits acceptDocs;
        protected final int maxDoc;
        protected TermsEnum termsEnum;
        protected DocsEnum docsEnum;

        public BaseTermsEnumTraverser(AtomicReaderContext context, Bits acceptDocs) throws IOException {
            this.context = context;
            AtomicReader reader = context.reader();
            this.acceptDocs = acceptDocs;
            this.maxDoc = reader.maxDoc();
            Terms terms = reader.terms(AbstractPrefixTreeFilter.this.fieldName);
            if (terms != null) {
                this.termsEnum = terms.iterator(null);
            }
        }

        protected void collectDocs(FixedBitSet bitSet) throws IOException {
            int docid;
            assert (this.termsEnum != null);
            this.docsEnum = this.termsEnum.docs(this.acceptDocs, this.docsEnum, 0);
            while ((docid = this.docsEnum.nextDoc()) != Integer.MAX_VALUE) {
                bitSet.set(docid);
            }
        }
    }
}

