/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.solr.util;

import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.spi.lifecycle.RepositoryInitializer;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;

public class SolrIndexInitializer
implements RepositoryInitializer {
    private static final String SOLR_IDX = "solr";
    private final String async;

    public SolrIndexInitializer() {
        this.async = "async";
    }

    public SolrIndexInitializer(boolean async) {
        this.async = async ? "async" : null;
    }

    public void initialize(@Nonnull NodeBuilder builder) {
        if (builder.hasChildNode("oak:index") && !builder.getChildNode("oak:index").hasChildNode(SOLR_IDX)) {
            builder = builder.getChildNode("oak:index").child(SOLR_IDX);
            builder.setProperty("jcr:primaryType", (Object)"oak:QueryIndexDefinition").setProperty("type", (Object)SOLR_IDX).setProperty("reindex", (Object)"true");
            if (this.async != null) {
                builder.setProperty("async", (Object)this.async);
            }
        }
    }
}

