/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.solr.osgi;

import java.io.File;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.oak.plugins.index.solr.configuration.EmbeddedSolrServerConfiguration;
import org.apache.jackrabbit.oak.plugins.index.solr.configuration.SolrServerConfiguration;
import org.apache.jackrabbit.oak.plugins.index.solr.configuration.SolrServerConfigurationProvider;
import org.apache.jackrabbit.oak.plugins.index.solr.server.EmbeddedSolrServerProvider;
import org.osgi.service.component.ComponentContext;

@Component(metatype=true, immediate=true, label="Oak Solr embedded server configuration")
@Service(value={SolrServerConfigurationProvider.class})
@Property(name="name", value={"embedded"}, propertyPrivate=true)
public class EmbeddedSolrServerConfigurationProvider
implements SolrServerConfigurationProvider<EmbeddedSolrServerProvider> {
    @Property(value={"solr"}, label="Solr home directory")
    private static final String SOLR_HOME_PATH = "solr.home.path";
    @Property(value={"oak"}, label="Solr Core name")
    private static final String SOLR_CORE_NAME = "solr.core.name";
    @Property(value={"solr.xml"}, label="Path to specific Solr Core configuration")
    private static final String SOLR_CONFIG_FILE = "solr.config.path";
    @Property(intValue={0}, label="Solr HTTP Endpoint port (optional)")
    private static final String SOLR_HTTP_PORT = "solr.http.port";
    @Property(value={""}, label="Solr HTTP Endpoint context (optional)")
    private static final String SOLR_CONTEXT = "solr.context";
    private String solrHome;
    private String solrConfigFile;
    private String solrCoreName;
    private Integer solrHttpPort;
    private String solrContext;
    private SolrServerConfiguration<EmbeddedSolrServerProvider> solrServerConfiguration;

    @Activate
    protected void activate(ComponentContext componentContext) throws Exception {
        this.solrHome = String.valueOf(componentContext.getProperties().get(SOLR_HOME_PATH));
        File file = new File(this.solrHome);
        if (!file.exists()) assert (file.createNewFile());
        this.solrConfigFile = String.valueOf(componentContext.getProperties().get(SOLR_CONFIG_FILE));
        this.solrCoreName = String.valueOf(componentContext.getProperties().get(SOLR_CORE_NAME));
        String httpPort = String.valueOf(componentContext.getProperties().get(SOLR_HTTP_PORT));
        if (httpPort != null && httpPort.length() > 0) {
            this.solrHttpPort = Integer.valueOf(httpPort);
        }
        this.solrContext = String.valueOf(componentContext.getProperties().get(SOLR_CONTEXT));
        this.solrServerConfiguration = new EmbeddedSolrServerConfiguration(this.solrHome, this.solrConfigFile, this.solrCoreName).withHttpConfiguration(this.solrContext, this.solrHttpPort);
    }

    @Deactivate
    protected void deactivate() throws Exception {
        this.solrHome = null;
        this.solrHttpPort = null;
        this.solrConfigFile = null;
        this.solrCoreName = null;
        this.solrContext = null;
    }

    @Override
    public SolrServerConfiguration<EmbeddedSolrServerProvider> getSolrServerConfiguration() {
        return this.solrServerConfiguration;
    }
}

