/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.mongomk;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentSkipListMap;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.mk.api.MicroKernelException;
import org.apache.jackrabbit.mongomk.DocumentStore;
import org.apache.jackrabbit.mongomk.UpdateOp;
import org.apache.jackrabbit.mongomk.util.Utils;

public class MemoryDocumentStore
implements DocumentStore {
    private ConcurrentSkipListMap<String, Map<String, Object>> nodes = new ConcurrentSkipListMap();
    private ConcurrentSkipListMap<String, Map<String, Object>> clusterNodes = new ConcurrentSkipListMap();

    @Override
    public Map<String, Object> find(DocumentStore.Collection collection, String key, int maxCacheAge) {
        return this.find(collection, key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> find(DocumentStore.Collection collection, String key) {
        ConcurrentSkipListMap<String, Map<String, Object>> map = this.getMap(collection);
        Map<String, Object> n = map.get(key);
        if (n == null) {
            return null;
        }
        Map<String, Object> copy = Utils.newMap();
        Map<String, Object> map2 = n;
        synchronized (map2) {
            Utils.deepCopyMap(n, copy);
        }
        return copy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public List<Map<String, Object>> query(DocumentStore.Collection collection, String fromKey, String toKey, int limit) {
        ConcurrentSkipListMap<String, Map<String, Object>> map = this.getMap(collection);
        SortedMap sub = map.subMap((Object)fromKey, (Object)toKey);
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (Map n : sub.values()) {
            Map copy = Utils.newMap();
            Map map2 = n;
            synchronized (map2) {
                Utils.deepCopyMap(n, copy);
            }
            list.add(copy);
            if (list.size() <= limit) continue;
            break;
        }
        return list;
    }

    @Override
    public void remove(DocumentStore.Collection collection, String path) {
        this.getMap(collection).remove(path);
    }

    private ConcurrentSkipListMap<String, Map<String, Object>> getMap(DocumentStore.Collection collection) {
        switch (collection) {
            case NODES: {
                return this.nodes;
            }
            case CLUSTER_NODES: {
                return this.clusterNodes;
            }
        }
        throw new IllegalArgumentException(collection.name());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckForNull
    private Map<String, Object> internalCreateOrUpdate(DocumentStore.Collection collection, UpdateOp update, boolean checkConditions) {
        Map<String, Object> n;
        ConcurrentSkipListMap<String, Map<String, Object>> map = this.getMap(collection);
        Map<String, Object> oldNode = n = map.get(update.key);
        if (n == null) {
            if (!update.isNew) {
                throw new MicroKernelException("Document does not exist: " + update.key);
            }
            n = Utils.newMap();
            oldNode = map.putIfAbsent(update.key, n);
            if (oldNode != null) {
                n = oldNode;
            }
        }
        Map<String, Object> map2 = n;
        synchronized (map2) {
            if (checkConditions && !MemoryDocumentStore.checkConditions(n, update)) {
                return null;
            }
            if (oldNode != null) {
                Map oldNode2 = Utils.newMap();
                Utils.deepCopyMap(oldNode, oldNode2);
                oldNode = oldNode2;
            }
            MemoryDocumentStore.applyChanges(n, update);
        }
        return oldNode;
    }

    @Override
    @Nonnull
    public Map<String, Object> createOrUpdate(DocumentStore.Collection collection, UpdateOp update) throws MicroKernelException {
        return this.internalCreateOrUpdate(collection, update, false);
    }

    @Override
    public Map<String, Object> findAndUpdate(DocumentStore.Collection collection, UpdateOp update) throws MicroKernelException {
        return this.internalCreateOrUpdate(collection, update, true);
    }

    private static boolean checkConditions(Map<String, Object> target, UpdateOp update) {
        for (Map.Entry<String, UpdateOp.Operation> change : update.changes.entrySet()) {
            UpdateOp.Operation op = change.getValue();
            if (op.type != UpdateOp.Operation.Type.CONTAINS_MAP_ENTRY) continue;
            String k = change.getKey();
            String[] kv = k.split("\\.");
            Object value = target.get(kv[0]);
            if (value == null) {
                if (!Boolean.TRUE.equals(op.value)) continue;
                return false;
            }
            if (value instanceof Collection) {
                Collection col = (Collection)value;
                if (!(Boolean.TRUE.equals(op.value) ? !col.contains(kv[1]) : col.contains(kv[1]))) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public static void applyChanges(Map<String, Object> target, UpdateOp update) {
        for (Map.Entry<String, UpdateOp.Operation> e : update.changes.entrySet()) {
            String k = e.getKey();
            String[] kv = k.split("\\.");
            UpdateOp.Operation op = e.getValue();
            switch (op.type) {
                case SET: {
                    target.put(k, op.value);
                    break;
                }
                case INCREMENT: {
                    Object old = target.get(k);
                    Long x = (Long)op.value;
                    if (old == null) {
                        old = 0L;
                    }
                    target.put(k, (Long)old + x);
                    break;
                }
                case SET_MAP_ENTRY: {
                    Object old = target.get(kv[0]);
                    Map<String, Object> m = (Map<String, Object>)old;
                    if (m == null) {
                        m = Utils.newMap();
                        target.put(kv[0], m);
                    }
                    m.put(kv[1], op.value);
                    break;
                }
                case REMOVE_MAP_ENTRY: {
                    Object old = target.get(kv[0]);
                    Map<String, Object> m = (Map)old;
                    if (m == null) break;
                    m.remove(kv[1]);
                    break;
                }
                case SET_MAP: {
                    Object old = target.get(kv[0]);
                    Map<String, Object> m = (Map)old;
                    if (m == null) {
                        m = Utils.newMap();
                        target.put(kv[0], m);
                    }
                    m.put(kv[1], op.value);
                    break;
                }
            }
        }
    }

    @Override
    public boolean create(DocumentStore.Collection collection, List<UpdateOp> updateOps) {
        ConcurrentSkipListMap<String, Map<String, Object>> map = this.getMap(collection);
        for (UpdateOp op : updateOps) {
            if (!map.containsKey(op.key)) continue;
            return false;
        }
        for (UpdateOp op : updateOps) {
            this.createOrUpdate(collection, op);
        }
        return true;
    }

    public String toString() {
        StringBuilder buff = new StringBuilder();
        buff.append("Nodes:\n");
        for (String p : this.nodes.keySet()) {
            buff.append("Path: ").append(p).append('\n');
            Map<String, Object> e = this.nodes.get(p);
            for (String prop : e.keySet()) {
                buff.append(prop).append('=').append(e.get(prop)).append('\n');
            }
            buff.append("\n");
        }
        return buff.toString();
    }

    @Override
    public void invalidateCache() {
    }

    @Override
    public void dispose() {
    }

    @Override
    public boolean isCached(DocumentStore.Collection collection, String key) {
        return false;
    }

    @Override
    public void invalidateCache(DocumentStore.Collection collection, String key) {
    }
}

