/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.mongomk;

import com.google.common.base.Preconditions;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.mongomk.Revision;

class Branch {
    private final SortedSet<Revision> commits;
    private final Revision base;

    Branch(@Nonnull SortedSet<Revision> commits, @Nonnull Revision base) {
        this.commits = (SortedSet)Preconditions.checkNotNull(commits);
        this.base = base;
    }

    synchronized Revision getHead() {
        return this.commits.last();
    }

    Revision getBase() {
        return this.base;
    }

    synchronized void addCommit(@Nonnull Revision r) {
        Preconditions.checkArgument((this.commits.comparator().compare(r, this.commits.last()) > 0 ? 1 : 0) != 0);
        this.commits.add(r);
    }

    synchronized SortedSet<Revision> getCommits() {
        return new TreeSet<Revision>(this.commits);
    }

    synchronized boolean containsCommit(@Nonnull Revision r) {
        return this.commits.contains(r);
    }

    public synchronized void removeCommit(@Nonnull Revision rev) {
        this.commits.remove(rev);
    }
}

