/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.mongomk;

import java.util.Map;
import java.util.TreeMap;

public class UpdateOp {
    static final String ID = "_id";
    static final String LAST_REV = "_lastRev";
    static final String REVISIONS = "_revisions";
    static final String COMMIT_ROOT = "_commitRoot";
    static final String PREVIOUS = "_prev";
    static final String DELETED = "_deleted";
    static final String COLLISIONS = "_collisions";
    static final String MODIFIED = "_modified";
    final String path;
    final String key;
    final boolean isNew;
    boolean isDelete;
    final Map<String, Operation> changes = new TreeMap<String, Operation>();

    UpdateOp(String path, String key, boolean isNew) {
        this.path = path;
        this.key = key;
        this.isNew = isNew;
    }

    String getPath() {
        return this.path;
    }

    String getKey() {
        return this.key;
    }

    boolean isNew() {
        return this.isNew;
    }

    void setDelete(boolean isDelete) {
        this.isDelete = isDelete;
    }

    void setMapEntry(String property, String subName, Object value) {
        Operation op = new Operation();
        op.type = Operation.Type.SET_MAP_ENTRY;
        op.value = value;
        this.changes.put(property + "." + subName, op);
    }

    public void removeMapEntry(String property, String subName) {
        Operation op = new Operation();
        op.type = Operation.Type.REMOVE_MAP_ENTRY;
        this.changes.put(property + "." + subName, op);
    }

    public void setMap(String property, String subName, Object value) {
        Operation op = new Operation();
        op.type = Operation.Type.SET_MAP;
        op.value = value;
        this.changes.put(property + "." + subName, op);
    }

    void set(String property, Object value) {
        Operation op = new Operation();
        op.type = Operation.Type.SET;
        op.value = value;
        this.changes.put(property, op);
    }

    void unset(String property) {
        this.changes.remove(property);
    }

    void unsetMapEntry(String property, String subName) {
        this.changes.remove(property + "." + subName);
    }

    void containsMapEntry(String property, String subName, boolean exists) {
        if (this.isNew) {
            throw new IllegalStateException("Cannot use containsMapEntry() on new document");
        }
        Operation op = new Operation();
        op.type = Operation.Type.CONTAINS_MAP_ENTRY;
        op.value = exists;
        this.changes.put(property + "." + subName, op);
    }

    void increment(String property, long value) {
        Operation op = new Operation();
        op.type = Operation.Type.INCREMENT;
        op.value = value;
        this.changes.put(property, op);
    }

    public Long getIncrement(String property) {
        Operation op = this.changes.get(property);
        if (op == null) {
            return null;
        }
        if (op.type != Operation.Type.INCREMENT) {
            throw new IllegalArgumentException("Not an increment operation");
        }
        return (Long)op.value;
    }

    public UpdateOp getReverseOperation() {
        UpdateOp reverse = new UpdateOp(this.path, this.key, this.isNew);
        for (Map.Entry<String, Operation> e : this.changes.entrySet()) {
            Operation r = e.getValue().getReverse();
            if (r == null) continue;
            reverse.changes.put(e.getKey(), r);
        }
        return reverse;
    }

    public String toString() {
        return "key: " + this.key + " " + (this.isNew ? "new" : "update") + " " + this.changes;
    }

    public static class Operation {
        Type type;
        Object value;

        public String toString() {
            return (Object)((Object)this.type) + " " + this.value;
        }

        public Operation getReverse() {
            Operation reverse = null;
            switch (this.type) {
                case INCREMENT: {
                    reverse = new Operation();
                    reverse.type = Type.INCREMENT;
                    reverse.value = -((Long)this.value).longValue();
                    break;
                }
                case SET: 
                case REMOVE_MAP_ENTRY: 
                case SET_MAP: 
                case CONTAINS_MAP_ENTRY: {
                    break;
                }
                case SET_MAP_ENTRY: {
                    reverse = new Operation();
                    reverse.type = Type.REMOVE_MAP_ENTRY;
                }
            }
            return reverse;
        }

        public static enum Type {
            SET,
            INCREMENT,
            SET_MAP_ENTRY,
            REMOVE_MAP_ENTRY,
            CONTAINS_MAP_ENTRY,
            SET_MAP;

        }
    }
}

