/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.mongomk;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class Revision {
    private static volatile long lastTimestamp;
    private static volatile long lastRevisionTimestamp;
    private static volatile int lastRevisionCount;
    private long timestamp;
    private int counter;
    private int clusterId;

    public Revision(long timestamp, int counter, int clusterId) {
        this.timestamp = timestamp;
        this.counter = counter;
        this.clusterId = clusterId;
    }

    int compareRevisionTime(Revision other) {
        int comp;
        int n = this.timestamp < other.timestamp ? -1 : (comp = this.timestamp > other.timestamp ? 1 : 0);
        if (comp == 0) {
            comp = this.counter < other.counter ? -1 : (this.counter > other.counter ? 1 : 0);
        }
        return comp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Revision newRevision(int clusterId) {
        long timestamp = Revision.getCurrentTimestamp();
        Class<Revision> clazz = Revision.class;
        synchronized (Revision.class) {
            int c;
            if (timestamp == lastRevisionTimestamp) {
                c = ++lastRevisionCount;
            } else {
                lastRevisionTimestamp = timestamp;
                c = 0;
                lastRevisionCount = 0;
            }
            // ** MonitorExit[var4_2] (shouldn't be in output)
            return new Revision(timestamp, c, clusterId);
        }
    }

    public static long getCurrentTimestamp() {
        long timestamp = System.currentTimeMillis();
        if (timestamp < lastTimestamp) {
            timestamp = lastTimestamp;
        } else if (timestamp > lastTimestamp) {
            lastTimestamp = timestamp;
        }
        return timestamp;
    }

    public static long getTimestampDifference(long a, long b) {
        return a - b;
    }

    public static Revision fromString(String rev) {
        if (!rev.startsWith("r")) {
            throw new IllegalArgumentException(rev);
        }
        int idxCount = rev.indexOf(45);
        if (idxCount < 0) {
            throw new IllegalArgumentException(rev);
        }
        int idxClusterId = rev.indexOf(45, idxCount + 1);
        if (idxClusterId < 0) {
            throw new IllegalArgumentException(rev);
        }
        String t = rev.substring(1, idxCount);
        long timestamp = Long.parseLong(t, 16);
        t = rev.substring(idxCount + 1, idxClusterId);
        int c = Integer.parseInt(t, 16);
        t = rev.substring(idxClusterId + 1);
        int clusterId = Integer.parseInt(t, 16);
        Revision r = new Revision(timestamp, c, clusterId);
        return r;
    }

    public String toString() {
        return "r" + Long.toHexString(this.timestamp) + '-' + Integer.toHexString(this.counter) + '-' + Integer.toHexString(this.clusterId);
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public int getCounter() {
        return this.counter;
    }

    public int hashCode() {
        return (int)(this.timestamp >>> 32) ^ (int)this.timestamp ^ this.counter ^ this.clusterId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other.getClass() != this.getClass()) {
            return false;
        }
        Revision r = (Revision)other;
        return r.timestamp == this.timestamp && r.counter == this.counter && r.clusterId == this.clusterId;
    }

    public int getClusterId() {
        return this.clusterId;
    }

    public static class RevisionComparator
    implements Comparator<Revision> {
        private final ConcurrentMap<Integer, List<RevisionRange>> map = new ConcurrentHashMap<Integer, List<RevisionRange>>();
        private long oldestTimestamp;

        public void purge(long timestamp) {
            this.oldestTimestamp = timestamp;
            Iterator i$ = this.map.keySet().iterator();
            while (i$.hasNext()) {
                List list;
                List<RevisionRange> newList;
                int clusterId = (Integer)i$.next();
                while (!((newList = this.purge(list = (List)this.map.get(clusterId))) == null ? this.map.remove(clusterId, list) : newList == list || this.map.replace(clusterId, list, newList))) {
                }
            }
        }

        private List<RevisionRange> purge(List<RevisionRange> list) {
            int i;
            for (i = 0; i < list.size(); ++i) {
                RevisionRange r = list.get(i);
                if (r.timestamp > this.oldestTimestamp) break;
            }
            if (i > list.size() - 1) {
                return null;
            }
            if (i == 0) {
                return list;
            }
            return new ArrayList<RevisionRange>(list.subList(i, list.size()));
        }

        public void add(Revision r, long timestamp) {
            ArrayList<RevisionRange> newList;
            List list;
            int clusterId = r.getClusterId();
            do {
                if ((list = (List)this.map.get(clusterId)) == null) {
                    newList = new ArrayList<RevisionRange>();
                } else {
                    RevisionRange last = (RevisionRange)list.get(list.size() - 1);
                    if (last.timestamp == timestamp) {
                        last.revision = r;
                        return;
                    }
                    newList = new ArrayList(list);
                }
                RevisionRange range = new RevisionRange();
                range.timestamp = timestamp;
                range.revision = r;
                newList.add(range);
            } while (!(list == null ? this.map.putIfAbsent(clusterId, newList) == null : this.map.replace(clusterId, list, newList)));
        }

        @Override
        public int compare(Revision o1, Revision o2) {
            if (o1.getClusterId() == o2.getClusterId()) {
                return o1.compareRevisionTime(o2);
            }
            RevisionRange range1 = this.getRevisionRange(o1);
            RevisionRange range2 = this.getRevisionRange(o2);
            if (range1 == null || range2 == null) {
                return o1.compareRevisionTime(o2);
            }
            if (range1.timestamp != range2.timestamp) {
                return range1.timestamp < range2.timestamp ? -1 : 1;
            }
            int result = o1.compareRevisionTime(o2);
            if (result != 0) {
                return result;
            }
            return o1.getClusterId() < o2.getClusterId() ? -1 : 1;
        }

        private RevisionRange getRevisionRange(Revision r) {
            List list = (List)this.map.get(r.getClusterId());
            if (list == null) {
                return null;
            }
            for (int i = list.size() - 1; i >= 0; --i) {
                RevisionRange range = (RevisionRange)list.get(i);
                if (r.compareRevisionTime(range.revision) < 0) continue;
                return range;
            }
            return null;
        }

        public String toString() {
            StringBuilder buff = new StringBuilder();
            Iterator i$ = new TreeSet(this.map.keySet()).iterator();
            while (i$.hasNext()) {
                int clusterId = (Integer)i$.next();
                buff.append(clusterId).append(':');
                for (RevisionRange r : (List)this.map.get(clusterId)) {
                    buff.append(' ').append(r);
                }
                buff.append("; ");
            }
            return buff.toString();
        }
    }

    static class RevisionRange {
        Revision revision;
        long timestamp;

        RevisionRange() {
        }

        public String toString() {
            return this.revision + ":" + this.timestamp;
        }
    }
}

