/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.mongomk;

import com.google.common.base.Preconditions;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.mongomk.DocumentStore;
import org.apache.jackrabbit.mongomk.MemoryDocumentStore;
import org.apache.jackrabbit.mongomk.Revision;
import org.apache.jackrabbit.mongomk.UpdateOp;
import org.apache.jackrabbit.mongomk.util.Utils;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Collision {
    private static final Logger log = LoggerFactory.getLogger(Collision.class);
    private final Map<String, Object> document;
    private final String theirRev;
    private final UpdateOp ourOp;
    private final String ourRev;

    Collision(@Nonnull Map<String, Object> document, @Nonnull Revision theirRev, @Nonnull UpdateOp ourOp, @Nonnull Revision ourRev) {
        this.document = (Map)Preconditions.checkNotNull(document);
        this.theirRev = ((Revision)Preconditions.checkNotNull((Object)theirRev)).toString();
        this.ourOp = (UpdateOp)Preconditions.checkNotNull((Object)ourOp);
        this.ourRev = ((Revision)Preconditions.checkNotNull((Object)ourRev)).toString();
    }

    boolean mark(DocumentStore store) {
        String value;
        if (Collision.markCommitRoot(this.document, this.theirRev, store)) {
            return true;
        }
        Map revisions = (Map)this.document.get("_revisions");
        if (revisions.containsKey(this.theirRev) && "true".equals(value = (String)revisions.get(this.theirRev))) {
            Map<String, Object> newDoc = Utils.newMap();
            Utils.deepCopyMap(this.document, newDoc);
            MemoryDocumentStore.applyChanges(newDoc, this.ourOp);
            if (Collision.markCommitRoot(newDoc, this.ourRev, store)) {
                return true;
            }
        }
        return true;
    }

    private static boolean markCommitRoot(@Nonnull Map<String, Object> document, @Nonnull String revision, @Nonnull DocumentStore store) {
        Integer depth;
        Map commitRoots = (Map)document.get("_commitRoot");
        if (commitRoots != null && (depth = (Integer)commitRoots.get(revision)) != null) {
            String p = Utils.getPathFromId((String)document.get("_id"));
            String commitRootPath = PathUtils.getAncestorPath((String)p, (int)(PathUtils.getDepth((String)p) - depth));
            UpdateOp op = new UpdateOp(commitRootPath, Utils.getIdFromPath(commitRootPath), false);
            op.setMapEntry("_collisions", revision, true);
            store.createOrUpdate(DocumentStore.Collection.NODES, op);
            log.debug("Marked collision on: {} for {} ({})", new Object[]{commitRootPath, p, revision});
            return true;
        }
        return false;
    }
}

