/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.mongomk.util;

import org.apache.jackrabbit.mk.model.tree.NodeState;
import org.apache.jackrabbit.mongomk.api.model.Node;
import org.apache.jackrabbit.mongomk.impl.model.tree.MongoNodeState;

public class MongoUtil {
    public static String fromMongoRepresentation(Long revisionId) {
        return String.valueOf(revisionId);
    }

    public static Long toMongoRepresentation(String revisionId) throws Exception {
        if (revisionId == null) {
            return null;
        }
        try {
            return Long.parseLong(revisionId);
        }
        catch (NumberFormatException e) {
            throw new Exception("Invalid revision id: " + revisionId);
        }
    }

    public static NodeState wrap(Node node) {
        return node != null ? new MongoNodeState(node) : null;
    }

    public static String adjustPath(String path) {
        return path == null || path.isEmpty() ? "/" : path;
    }

    public static boolean isFiltered(String path) {
        return !"/".equals(path);
    }

    public static String fromMongoPropertyKey(String key) {
        if (key.startsWith("[dollar]")) {
            return key.replaceFirst("\\[dollar\\]", "\\$");
        }
        if (key.contains("[dot]")) {
            return key.replaceAll("\\[dot\\]", "\\.");
        }
        return key;
    }

    public static String toMongoPropertyKey(String key) {
        if (key.startsWith("$")) {
            return key.replaceFirst("\\$", "[dollar]");
        }
        if (key.contains(".")) {
            return key.replaceAll("\\.", "[dot]");
        }
        return key;
    }
}

