/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.mongomk.osgi;

import com.mongodb.DB;
import java.util.Dictionary;
import java.util.Map;
import java.util.Properties;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Property;
import org.apache.jackrabbit.mk.api.MicroKernel;
import org.apache.jackrabbit.mongomk.impl.MongoConnection;
import org.apache.jackrabbit.mongomk.impl.MongoMicroKernel;
import org.apache.jackrabbit.mongomk.impl.MongoNodeStore;
import org.apache.jackrabbit.mongomk.impl.blob.MongoGridFSBlobStore;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Deactivate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=true, label="%oak.mongomk.label", description="%oak.mongomk.description", policy=ConfigurationPolicy.REQUIRE)
public class MongoMicroKernelService {
    private static final String DEFAULT_HOST = "localhost";
    private static final int DEFAULT_PORT = 27017;
    private static final String DEFAULT_DB = "oak";
    @Property(value={"localhost"})
    private static final String PROP_HOST = "host";
    @Property(intValue={27017})
    private static final String PROP_PORT = "port";
    @Property(value={"oak"})
    private static final String PROP_DB = "db";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private ServiceRegistration reg;
    private MongoMicroKernel mk;

    @Activate
    private void activate(BundleContext context, Map<String, ?> config) throws Exception {
        String host = PropertiesUtil.toString(config.get(PROP_HOST), DEFAULT_HOST);
        int port = PropertiesUtil.toInteger(config.get(PROP_PORT), 27017);
        String db = PropertiesUtil.toString(config.get(PROP_DB), DEFAULT_DB);
        this.logger.info("Starting MongoDB MicroKernel with host={}, port={}, db={}", new Object[]{host, port, db});
        MongoConnection connection = new MongoConnection(host, port, db);
        DB mongoDB = connection.getDB();
        this.logger.info("Connected to database {}", (Object)mongoDB);
        MongoNodeStore nodeStore = new MongoNodeStore(mongoDB);
        MongoGridFSBlobStore blobStore = new MongoGridFSBlobStore(mongoDB);
        MongoMicroKernel mk = new MongoMicroKernel(connection, nodeStore, blobStore);
        Properties props = new Properties();
        props.setProperty("oak.mk.type", "mongo");
        this.reg = context.registerService(MicroKernel.class.getName(), (Object)mk, (Dictionary)props);
    }

    @Deactivate
    private void deactivate() {
        if (this.reg != null) {
            this.reg.unregister();
        }
        if (this.mk != null) {
            this.mk.dispose();
        }
    }
}

