/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.mongomk.impl.model;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.jackrabbit.mk.model.ChildNodeEntry;
import org.apache.jackrabbit.mk.model.NodeDiffHandler;
import org.apache.jackrabbit.mk.util.RangeIterator;
import org.apache.jackrabbit.mongomk.api.model.Node;
import org.apache.jackrabbit.oak.commons.PathUtils;

public class NodeImpl
implements Node {
    private static final List<Node> EMPTY = Collections.emptyList();
    private Map<String, Node> childEntries;
    private String path;
    private Map<String, String> properties;
    private Long revisionId;

    public NodeImpl(String path) {
        this.path = path;
        this.childEntries = new HashMap<String, Node>();
        this.properties = new HashMap<String, String>();
    }

    public void addChildNodeEntry(Node child) {
        String childName = PathUtils.getName((String)child.getPath());
        this.childEntries.put(childName, child);
    }

    @Override
    public Node getChildNodeEntry(String name) {
        return this.childEntries.get(name);
    }

    @Override
    public int getChildNodeCount() {
        return this.childEntries.size();
    }

    @Override
    public Iterator<Node> getChildNodeEntries(int offset, int count) {
        if (offset < 0 || count < -1) {
            throw new IllegalArgumentException();
        }
        if (offset == 0 && count == -1) {
            return this.childEntries.values().iterator();
        }
        if (offset >= this.childEntries.size() || count == 0) {
            return EMPTY.iterator();
        }
        if (count == -1 || offset + count > this.childEntries.size()) {
            count = this.childEntries.size() - offset;
        }
        return new RangeIterator(this.childEntries.values().iterator(), offset, count);
    }

    public void removeChildNodeEntry(String name) {
        this.childEntries.remove(name);
    }

    public void addProperty(String key, String value) {
        this.properties.put(key, value);
    }

    @Override
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public Long getRevisionId() {
        return this.revisionId;
    }

    public void setRevisionId(Long revisionId) {
        this.revisionId = revisionId;
    }

    @Override
    public void diff(Node other, NodeDiffHandler handler) {
        String childName;
        Node child;
        String name;
        Map<String, String> oldProps = this.getProperties();
        Map<String, String> newProps = other.getProperties();
        for (Map.Entry<String, String> entry : oldProps.entrySet()) {
            name = entry.getKey();
            String val = oldProps.get(name);
            String newVal = newProps.get(name);
            if (newVal == null) {
                handler.propDeleted(name, val.toString());
                continue;
            }
            if (val.equals(newVal)) continue;
            handler.propChanged(name, val.toString(), newVal.toString());
        }
        for (Map.Entry<String, String> entry : newProps.entrySet()) {
            name = entry.getKey();
            if (oldProps.containsKey(name)) continue;
            handler.propAdded(name, entry.getValue().toString());
        }
        Iterator<Node> it = this.getChildNodeEntries(0, -1);
        while (it.hasNext()) {
            child = it.next();
            childName = PathUtils.getName((String)child.getPath());
            Node newChild = other.getChildNodeEntry(childName);
            if (newChild == null) {
                handler.childNodeDeleted(new ChildNodeEntry(childName, null));
                continue;
            }
            if (child.equals(newChild)) continue;
            handler.childNodeChanged(new ChildNodeEntry(childName, null), null);
        }
        it = other.getChildNodeEntries(0, -1);
        while (it.hasNext()) {
            child = it.next();
            childName = PathUtils.getName((String)child.getPath());
            if (this.getChildNodeEntry(childName) != null) continue;
            handler.childNodeAdded(new ChildNodeEntry(childName, null));
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.childEntries == null ? 0 : this.childEntries.hashCode());
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
        result = 31 * result + (this.revisionId == null ? 0 : this.revisionId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NodeImpl other = (NodeImpl)obj;
        if (this.childEntries == null ? other.childEntries != null : !this.childEntries.equals(other.childEntries)) {
            return false;
        }
        if (this.path == null ? other.path != null : !this.path.equals(other.path)) {
            return false;
        }
        if (this.properties == null ? other.properties != null : !this.properties.equals(other.properties)) {
            return false;
        }
        return !(this.revisionId == null ? other.revisionId != null : !this.revisionId.equals(other.revisionId));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("NodeImpl ");
        builder.append("path=");
        builder.append(this.path);
        if (this.revisionId != null) {
            builder.append(", revisionId=");
            builder.append(this.revisionId);
        }
        if (!this.childEntries.isEmpty()) {
            builder.append(", children=[");
            Set<String> childNames = this.childEntries.keySet();
            int childCount = childNames.size();
            int i = 0;
            for (String childName : this.childEntries.keySet()) {
                if (i++ < childCount - 1) {
                    builder.append(childName + ", ");
                    continue;
                }
                builder.append(childName);
            }
            builder.append("]");
        }
        if (!this.properties.isEmpty()) {
            builder.append(", properties=");
            builder.append(this.properties);
        }
        return builder.toString();
    }
}

