/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.mongomk.impl.model;

import com.mongodb.BasicDBObject;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.jackrabbit.mk.json.JsopBuilder;
import org.apache.jackrabbit.mongomk.impl.model.NodeImpl;
import org.apache.jackrabbit.oak.commons.PathUtils;

public class MongoNode
extends BasicDBObject {
    public static final String KEY_CHILDREN = "children";
    public static final String KEY_DELETED = "deleted";
    public static final String KEY_PATH = "path";
    public static final String KEY_PROPERTIES = "props";
    public static final String KEY_REVISION_ID = "revId";
    public static final String KEY_BRANCH_ID = "branchId";
    private static final long serialVersionUID = 3153393934945155106L;
    private List<String> addedChildren;
    private Map<String, Object> addedProps;
    private List<String> removedChildren;
    private Map<String, Object> removedProps;

    public static NodeImpl toNode(MongoNode nodeMongo) {
        String path = nodeMongo.getPath();
        NodeImpl nodeImpl = new NodeImpl(path);
        List<String> childNames = nodeMongo.getChildren();
        if (childNames != null) {
            for (String string : childNames) {
                String childPath = PathUtils.concat((String)path, (String)string);
                NodeImpl child = new NodeImpl(childPath);
                nodeImpl.addChildNodeEntry(child);
            }
        }
        nodeImpl.setRevisionId(nodeMongo.getRevisionId());
        for (Map.Entry entry : nodeMongo.getProperties().entrySet()) {
            nodeImpl.addProperty((String)entry.getKey(), MongoNode.convertObjectValue(entry.getValue()));
        }
        return nodeImpl;
    }

    private static String convertObjectValue(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return JsopBuilder.encode((String)value.toString());
        }
        return value.toString();
    }

    public String getBranchId() {
        return this.getString(KEY_BRANCH_ID);
    }

    public void setBranchId(String branchId) {
        this.put(KEY_BRANCH_ID, branchId);
    }

    public List<String> getChildren() {
        return (List)this.get(KEY_CHILDREN);
    }

    public void setChildren(List<String> children) {
        if (children != null) {
            this.put(KEY_CHILDREN, children);
        } else {
            this.removeField(KEY_CHILDREN);
        }
    }

    public boolean isDeleted() {
        return this.getBoolean(KEY_DELETED);
    }

    public void setDeleted(boolean deleted) {
        if (deleted) {
            this.put(KEY_DELETED, Boolean.TRUE);
        } else {
            this.remove(KEY_DELETED);
        }
    }

    public String getPath() {
        return this.getString(KEY_PATH);
    }

    public void setPath(String path) {
        this.put(KEY_PATH, path);
    }

    public Map<String, Object> getProperties() {
        Object properties = this.get(KEY_PROPERTIES);
        return properties != null ? (Map)properties : new HashMap();
    }

    public void setProperties(Map<String, Object> properties) {
        if (properties != null && !properties.isEmpty()) {
            this.put(KEY_PROPERTIES, properties);
        } else {
            this.removeField(KEY_PROPERTIES);
        }
    }

    public Long getRevisionId() {
        return this.getLong(KEY_REVISION_ID);
    }

    public void setRevisionId(long revisionId) {
        this.put(KEY_REVISION_ID, revisionId);
    }

    public MongoNode copy() {
        MongoNode copy = new MongoNode();
        copy.putAll((Map)super.copy());
        return copy;
    }

    public void addChild(String childName) {
        if (this.removedChildren != null && this.removedChildren.remove(childName)) {
            return;
        }
        if (this.addedChildren == null) {
            this.addedChildren = new LinkedList<String>();
        }
        if (!this.addedChildren.contains(childName)) {
            this.addedChildren.add(childName);
        }
    }

    public List<String> getAddedChildren() {
        return this.addedChildren;
    }

    public void removeChild(String childName) {
        if (this.addedChildren != null && this.addedChildren.remove(childName)) {
            return;
        }
        if (this.removedChildren == null) {
            this.removedChildren = new LinkedList<String>();
        }
        if (!this.removedChildren.contains(childName)) {
            this.removedChildren.add(childName);
        }
    }

    public List<String> getRemovedChildren() {
        return this.removedChildren;
    }

    public void addProperty(String key, Object value) {
        if (this.addedProps == null) {
            this.addedProps = new HashMap<String, Object>();
        }
        this.addedProps.put(key, value);
    }

    public Map<String, Object> getAddedProps() {
        return this.addedProps;
    }

    public void removeProp(String key) {
        if (this.removedProps == null) {
            this.removedProps = new HashMap<String, Object>();
        }
        this.removedProps.put(key, null);
    }

    public Map<String, Object> getRemovedProps() {
        return this.removedProps;
    }

    public boolean childExists(String childName) {
        List<String> children = this.getChildren();
        if (children != null && !children.isEmpty() && children.contains(childName) && !this.childExistsInRemovedChildren(childName)) {
            return true;
        }
        return this.childExistsInAddedChildren(childName);
    }

    private boolean childExistsInAddedChildren(String childName) {
        return this.addedChildren != null && !this.addedChildren.isEmpty() ? this.addedChildren.contains(childName) : false;
    }

    private boolean childExistsInRemovedChildren(String childName) {
        return this.removedChildren != null && !this.removedChildren.isEmpty() ? this.removedChildren.contains(childName) : false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.deleteCharAt(sb.length() - 1);
        if (this.addedChildren != null && !this.addedChildren.isEmpty()) {
            sb.append(", addedChildren : ");
            sb.append(this.addedChildren);
        }
        if (this.removedChildren != null && !this.removedChildren.isEmpty()) {
            sb.append(", removedChildren : ");
            sb.append(this.removedChildren);
        }
        if (this.addedProps != null && !this.addedProps.isEmpty()) {
            sb.append(", addedProps : ");
            sb.append(this.addedProps);
        }
        if (this.removedProps != null && !this.removedProps.isEmpty()) {
            sb.append(", removedProps : ");
            sb.append(this.removedProps);
        }
        sb.append(" }");
        return sb.toString();
    }
}

