/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.mongomk.impl.model;

import com.mongodb.BasicDBObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.jackrabbit.mongomk.api.instruction.Instruction;
import org.apache.jackrabbit.mongomk.api.model.Commit;

public class MongoCommit
extends BasicDBObject
implements Commit {
    public static final String KEY_AFFECTED_PATH = "affPaths";
    public static final String KEY_BASE_REVISION_ID = "baseRevId";
    public static final String KEY_BRANCH_ID = "branchId";
    public static final String KEY_DIFF = "diff";
    public static final String KEY_FAILED = "failed";
    public static final String KEY_MESSAGE = "msg";
    public static final String KEY_PATH = "path";
    public static final String KEY_REVISION_ID = "revId";
    public static final String KEY_TIMESTAMP = "ts";
    private final List<Instruction> instructions = new LinkedList<Instruction>();
    private SortedSet<String> affectedPaths;
    private static final long serialVersionUID = 6656294757102309827L;

    public MongoCommit() {
        this.setTimestamp(new Date().getTime());
    }

    @Override
    public SortedSet<String> getAffectedPaths() {
        if (this.affectedPaths == null) {
            this.affectedPaths = new TreeSet<String>(this.inflate((byte[])this.get(KEY_AFFECTED_PATH)));
        }
        return Collections.unmodifiableSortedSet(this.affectedPaths);
    }

    public void setAffectedPaths(Set<String> affectedPaths) {
        this.affectedPaths = new TreeSet<String>(affectedPaths);
        this.put(KEY_AFFECTED_PATH, this.compress(this.affectedPaths));
    }

    @Override
    public Long getBaseRevisionId() {
        return this.containsField(KEY_BASE_REVISION_ID) ? Long.valueOf(this.getLong(KEY_BASE_REVISION_ID)) : null;
    }

    public void setBaseRevisionId(Long baseRevisionId) {
        if (baseRevisionId == null) {
            this.removeField(KEY_BASE_REVISION_ID);
        } else {
            this.put(KEY_BASE_REVISION_ID, baseRevisionId);
        }
    }

    @Override
    public String getBranchId() {
        return this.getString(KEY_BRANCH_ID);
    }

    public void setBranchId(String branchId) {
        this.put(KEY_BRANCH_ID, branchId);
    }

    @Override
    public String getDiff() {
        List<String> data = this.inflate((byte[])this.get(KEY_DIFF));
        if (data == null || data.isEmpty()) {
            return null;
        }
        return data.get(0);
    }

    public void setDiff(String diff) {
        this.put(KEY_DIFF, this.compress(Collections.singleton(diff)));
    }

    @Override
    public boolean isFailed() {
        return this.getBoolean(KEY_FAILED);
    }

    public void setFailed() {
        this.put(KEY_FAILED, Boolean.TRUE);
    }

    @Override
    public String getMessage() {
        return this.getString(KEY_MESSAGE);
    }

    public void setMessage(String message) {
        this.put(KEY_MESSAGE, message);
    }

    @Override
    public String getPath() {
        return this.getString(KEY_PATH);
    }

    public void setPath(String path) {
        this.put(KEY_PATH, path);
    }

    @Override
    public Long getRevisionId() {
        return this.containsField(KEY_REVISION_ID) ? Long.valueOf(this.getLong(KEY_REVISION_ID)) : null;
    }

    @Override
    public void setRevisionId(Long revisionId) {
        this.put(KEY_REVISION_ID, revisionId);
    }

    @Override
    public Long getTimestamp() {
        return this.getLong(KEY_TIMESTAMP);
    }

    public void setTimestamp(Long timestamp) {
        this.put(KEY_TIMESTAMP, timestamp);
    }

    public void addInstruction(Instruction instruction) {
        this.instructions.add(instruction);
    }

    @Override
    public List<Instruction> getInstructions() {
        return Collections.unmodifiableList(this.instructions);
    }

    private List<String> inflate(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        ArrayList<String> data = new ArrayList<String>();
        try {
            DataInputStream in = new DataInputStream(new GZIPInputStream(new ByteArrayInputStream(bytes)));
            int num = in.readInt();
            for (int i = 0; i < num; ++i) {
                int len = in.readInt();
                byte[] buffer = new byte[len];
                in.readFully(buffer);
                data.add(new String(buffer, "UTF-8"));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return data;
    }

    private byte[] compress(Collection<String> strings) {
        try {
            ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
            GZIPOutputStream out = new GZIPOutputStream(byteOut);
            DataOutputStream dataOut = new DataOutputStream(out);
            dataOut.writeInt(strings.size());
            for (String s : strings) {
                byte[] buffer = s.getBytes("UTF-8");
                dataOut.writeInt(buffer.length);
                dataOut.write(buffer);
            }
            dataOut.close();
            ((OutputStream)out).close();
            return byteOut.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

