/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.mongomk.impl.model;

import org.apache.jackrabbit.mongomk.api.model.Commit;
import org.apache.jackrabbit.mongomk.impl.instruction.AddNodeInstructionImpl;
import org.apache.jackrabbit.mongomk.impl.instruction.CopyNodeInstructionImpl;
import org.apache.jackrabbit.mongomk.impl.instruction.MoveNodeInstructionImpl;
import org.apache.jackrabbit.mongomk.impl.instruction.RemoveNodeInstructionImpl;
import org.apache.jackrabbit.mongomk.impl.instruction.SetPropertyInstructionImpl;
import org.apache.jackrabbit.mongomk.impl.json.DefaultJsopHandler;
import org.apache.jackrabbit.mongomk.impl.json.JsopParser;
import org.apache.jackrabbit.mongomk.impl.model.MongoCommit;
import org.apache.jackrabbit.mongomk.util.MongoUtil;

public class CommitBuilder {
    public static Commit build(String path, String diff, String message) throws Exception {
        return CommitBuilder.build(path, diff, null, message);
    }

    public static Commit build(String path, String diff, String revisionId, String message) throws Exception {
        MongoCommit commit = new MongoCommit();
        commit.setBaseRevisionId(MongoUtil.toMongoRepresentation(revisionId));
        commit.setDiff(diff);
        commit.setMessage(message);
        commit.setPath(path);
        JsopParser jsopParser = new JsopParser(path, diff, new CommitHandler(commit));
        jsopParser.parse();
        return commit;
    }

    private static class CommitHandler
    extends DefaultJsopHandler {
        private final MongoCommit commit;

        CommitHandler(MongoCommit commit) {
            this.commit = commit;
        }

        @Override
        public void nodeAdded(String parentPath, String name) {
            this.commit.addInstruction(new AddNodeInstructionImpl(parentPath, name));
        }

        @Override
        public void nodeCopied(String rootPath, String oldPath, String newPath) {
            this.commit.addInstruction(new CopyNodeInstructionImpl(rootPath, oldPath, newPath));
        }

        @Override
        public void nodeMoved(String rootPath, String oldPath, String newPath) {
            this.commit.addInstruction(new MoveNodeInstructionImpl(rootPath, oldPath, newPath));
        }

        @Override
        public void nodeRemoved(String parentPath, String name) {
            this.commit.addInstruction(new RemoveNodeInstructionImpl(parentPath, name));
        }

        @Override
        public void propertySet(String path, String key, Object value, String rawValue) {
            this.commit.addInstruction(new SetPropertyInstructionImpl(path, MongoUtil.toMongoPropertyKey(key), value));
        }
    }
}

