/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.mongomk.impl.json;

import org.apache.jackrabbit.mk.json.JsopTokenizer;
import org.apache.jackrabbit.mongomk.impl.json.DefaultJsopHandler;
import org.apache.jackrabbit.mongomk.impl.json.JsonUtil;
import org.apache.jackrabbit.oak.commons.PathUtils;

public class JsopParser {
    private final DefaultJsopHandler defaultHandler;
    private final String path;
    private final JsopTokenizer tokenizer;

    public JsopParser(String path, String jsonDiff, DefaultJsopHandler defaultHandler) {
        this.path = path;
        this.defaultHandler = defaultHandler;
        this.tokenizer = new JsopTokenizer(jsonDiff);
    }

    public void parse() throws Exception {
        int token;
        if (this.path.length() > 0 && !PathUtils.isAbsolute((String)this.path)) {
            throw new IllegalArgumentException("Absolute path expected: " + this.path);
        }
        block7: while ((token = this.tokenizer.read()) != 0) {
            switch (token) {
                case 43: {
                    this.parseOpAdded(this.path);
                    continue block7;
                }
                case 42: {
                    this.parseOpCopied();
                    continue block7;
                }
                case 62: {
                    this.parseOpMoved();
                    continue block7;
                }
                case 94: {
                    this.parseOpSet();
                    continue block7;
                }
                case 45: {
                    this.parseOpRemoved();
                    continue block7;
                }
            }
            throw new IllegalArgumentException("Illegal token '" + (char)token);
        }
    }

    private void parseOpAdded(String currentPath) throws Exception {
        String subPath = this.tokenizer.readString();
        this.tokenizer.read(58);
        String path = PathUtils.concat((String)currentPath, (String)subPath);
        if (this.tokenizer.matches(123)) {
            String parentPath = PathUtils.denotesRoot((String)path) ? "" : PathUtils.getParentPath((String)path);
            String nodeName = PathUtils.denotesRoot((String)path) ? "/" : PathUtils.getName((String)path);
            this.defaultHandler.nodeAdded(parentPath, nodeName);
            if (!this.tokenizer.matches(125)) {
                do {
                    int pos = this.tokenizer.getLastPos();
                    String propName = this.tokenizer.readString();
                    this.tokenizer.read(58);
                    if (this.tokenizer.matches(123)) {
                        this.tokenizer.setPos(pos);
                        this.tokenizer.read();
                        this.parseOpAdded(path);
                        continue;
                    }
                    String valueAsString = this.tokenizer.readRawValue().trim();
                    Object value = JsonUtil.toJsonValue(valueAsString);
                    this.defaultHandler.propertySet(path, propName, value, valueAsString);
                } while (this.tokenizer.matches(44));
                this.tokenizer.read(125);
            }
        }
    }

    private void parseOpCopied() throws Exception {
        int pos = this.tokenizer.getLastPos();
        String subPath = this.tokenizer.readString();
        String srcPath = PathUtils.concat((String)this.path, (String)subPath);
        if (!PathUtils.isAbsolute((String)srcPath)) {
            throw new Exception("Absolute path expected: " + srcPath + ", pos: " + pos);
        }
        this.tokenizer.read(58);
        String targetPath = this.tokenizer.readString();
        if (!PathUtils.isAbsolute((String)targetPath) && !PathUtils.isAbsolute((String)(targetPath = PathUtils.concat((String)this.path, (String)targetPath)))) {
            throw new Exception("Absolute path expected: " + targetPath + ", pos: " + pos);
        }
        this.defaultHandler.nodeCopied(this.path, srcPath, targetPath);
    }

    private void parseOpMoved() throws Exception {
        int pos = this.tokenizer.getLastPos();
        String subPath = this.tokenizer.readString();
        String srcPath = PathUtils.concat((String)this.path, (String)subPath);
        if (!PathUtils.isAbsolute((String)srcPath)) {
            throw new Exception("Absolute path expected: " + srcPath + ", pos: " + pos);
        }
        this.tokenizer.read(58);
        pos = this.tokenizer.getLastPos();
        String targetPath = this.tokenizer.readString();
        if (!PathUtils.isAbsolute((String)targetPath) && !PathUtils.isAbsolute((String)(targetPath = PathUtils.concat((String)this.path, (String)targetPath)))) {
            throw new Exception("absolute path expected: " + targetPath + ", pos: " + pos);
        }
        this.defaultHandler.nodeMoved(this.path, srcPath, targetPath);
    }

    private void parseOpSet() throws Exception {
        int pos = this.tokenizer.getLastPos();
        String subPath = this.tokenizer.readString();
        this.tokenizer.read(58);
        String value = this.tokenizer.matches(5) ? null : this.tokenizer.readRawValue().trim();
        String targetPath = PathUtils.concat((String)this.path, (String)subPath);
        if (!PathUtils.isAbsolute((String)targetPath)) {
            throw new Exception("Absolute path expected: " + targetPath + ", pos: " + pos);
        }
        String parentPath = PathUtils.getParentPath((String)targetPath);
        String propName = PathUtils.getName((String)targetPath);
        this.defaultHandler.propertySet(parentPath, propName, JsonUtil.toJsonValue(value), value);
    }

    private void parseOpRemoved() throws Exception {
        int pos = this.tokenizer.getLastPos();
        String subPath = this.tokenizer.readString();
        String targetPath = PathUtils.concat((String)this.path, (String)subPath);
        if (!PathUtils.isAbsolute((String)targetPath)) {
            throw new Exception("Absolute path expected: " + targetPath + ", pos: " + pos);
        }
        this.defaultHandler.nodeRemoved(this.path, subPath);
    }
}

