/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.mongomk.impl.command;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.jackrabbit.mk.json.JsopBuilder;
import org.apache.jackrabbit.mk.model.tree.DiffBuilder;
import org.apache.jackrabbit.mongomk.impl.MongoNodeStore;
import org.apache.jackrabbit.mongomk.impl.action.FetchCommitAction;
import org.apache.jackrabbit.mongomk.impl.action.FetchNodesActionNew;
import org.apache.jackrabbit.mongomk.impl.command.BaseCommand;
import org.apache.jackrabbit.mongomk.impl.model.MongoCommit;
import org.apache.jackrabbit.mongomk.impl.model.MongoNode;
import org.apache.jackrabbit.mongomk.impl.model.NodeImpl;
import org.apache.jackrabbit.mongomk.impl.model.tree.SimpleMongoNodeStore;
import org.apache.jackrabbit.mongomk.util.MongoUtil;
import org.apache.jackrabbit.oak.commons.PathUtils;

public class OneLevelDiffCommand
extends BaseCommand<String> {
    private final long fromRevision;
    private final long toRevision;
    private final String path;
    private final int pathDepth;

    public OneLevelDiffCommand(MongoNodeStore nodeStore, String fromRevision, String toRevision, String path) throws Exception {
        super(nodeStore);
        this.fromRevision = MongoUtil.toMongoRepresentation((String)Preconditions.checkNotNull((Object)fromRevision));
        this.toRevision = MongoUtil.toMongoRepresentation((String)Preconditions.checkNotNull((Object)toRevision));
        this.path = MongoUtil.adjustPath(path);
        this.pathDepth = PathUtils.getDepth((String)this.path);
    }

    @Override
    public String execute() throws Exception {
        MongoCommit fromCommit = new FetchCommitAction(this.nodeStore, this.fromRevision).execute();
        MongoCommit toCommit = new FetchCommitAction(this.nodeStore, this.toRevision).execute();
        FetchNodesActionNew action = new FetchNodesActionNew(this.nodeStore, this.path, 0, this.fromRevision);
        action.setBranchId(fromCommit.getBranchId());
        NodeImpl fromNode = MongoNode.toNode((MongoNode)((Object)action.execute().get(this.path)));
        action = new FetchNodesActionNew(this.nodeStore, this.path, 0, this.toRevision);
        action.setBranchId(toCommit.getBranchId());
        NodeImpl toNode = MongoNode.toNode((MongoNode)((Object)action.execute().get(this.path)));
        String diff = "";
        if (!fromNode.getRevisionId().equals(toNode.getRevisionId())) {
            DiffBuilder diffBuilder = new DiffBuilder(MongoUtil.wrap(fromNode), MongoUtil.wrap(toNode), this.path, 0, new SimpleMongoNodeStore(), this.path);
            diff = diffBuilder.build();
        }
        List<MongoCommit> commits = this.getCommits(fromCommit, toCommit);
        HashSet<String> affectedPaths = new HashSet<String>();
        String from = (PathUtils.denotesRoot((String)this.path) ? this.path : this.path + "/") + "\u0000";
        String to = (PathUtils.denotesRoot((String)this.path) ? this.path : this.path + "/") + "\uffff";
        for (MongoCommit mc : commits) {
            for (String p : mc.getAffectedPaths().subSet(from, to)) {
                int d = PathUtils.getDepth((String)p);
                if (d <= this.pathDepth) continue;
                affectedPaths.add(PathUtils.getAncestorPath((String)p, (int)(d - this.pathDepth - 1)));
            }
        }
        JsopBuilder builder = new JsopBuilder();
        for (String p : affectedPaths) {
            builder.tag('^');
            builder.key(p);
            builder.object().endObject();
            builder.newline();
        }
        return diff + builder.toString();
    }

    private List<MongoCommit> getCommits(MongoCommit c1, MongoCommit c2) throws Exception {
        ArrayList<MongoCommit> commits = new ArrayList<MongoCommit>();
        MongoCommit fromCommit = c1.getRevisionId() < c2.getRevisionId() ? c1 : c2;
        MongoCommit toCommit = c1.getRevisionId() < c2.getRevisionId() ? c2 : c1;
        Long revision = toCommit.getBaseRevisionId();
        commits.add(toCommit);
        while (revision != null && revision > fromCommit.getRevisionId()) {
            MongoCommit c = new FetchCommitAction(this.nodeStore, revision).execute();
            commits.add(c);
            revision = c.getBaseRevisionId();
        }
        commits.add(fromCommit);
        return commits;
    }
}

