/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.mongomk.impl.command;

import java.util.ArrayList;
import org.apache.jackrabbit.mk.api.MicroKernelException;
import org.apache.jackrabbit.mk.json.JsopBuilder;
import org.apache.jackrabbit.mk.model.tree.DiffBuilder;
import org.apache.jackrabbit.mongomk.api.model.Node;
import org.apache.jackrabbit.mongomk.impl.MongoNodeStore;
import org.apache.jackrabbit.mongomk.impl.action.FetchCommitsAction;
import org.apache.jackrabbit.mongomk.impl.command.BaseCommand;
import org.apache.jackrabbit.mongomk.impl.command.GetNodesCommandNew;
import org.apache.jackrabbit.mongomk.impl.model.MongoCommit;
import org.apache.jackrabbit.mongomk.impl.model.tree.SimpleMongoNodeStore;
import org.apache.jackrabbit.mongomk.util.MongoUtil;

public class GetRevisionHistoryCommand
extends BaseCommand<String> {
    private final long since;
    private int maxEntries;
    private String path;

    public GetRevisionHistoryCommand(MongoNodeStore nodeStore, long since, int maxEntries, String path) {
        super(nodeStore);
        this.since = since;
        this.maxEntries = maxEntries;
        this.path = path;
    }

    @Override
    public String execute() {
        this.path = MongoUtil.adjustPath(this.path);
        this.maxEntries = this.maxEntries < 0 ? Integer.MAX_VALUE : this.maxEntries;
        FetchCommitsAction action = new FetchCommitsAction(this.nodeStore);
        action.setMaxEntries(this.maxEntries);
        action.includeBranchCommits(false);
        Object commits = action.execute();
        ArrayList<MongoCommit> history = new ArrayList<MongoCommit>();
        for (int i = commits.size() - 1; i >= 0; --i) {
            MongoCommit commit = (MongoCommit)commits.get(i);
            if (commit.getTimestamp() < this.since) continue;
            if (MongoUtil.isFiltered(this.path)) {
                try {
                    String diff = new DiffBuilder(MongoUtil.wrap(this.getNode("/", commit.getBaseRevisionId())), MongoUtil.wrap(this.getNode("/", commit.getRevisionId())), "/", -1, new SimpleMongoNodeStore(), this.path).build();
                    if (diff.isEmpty()) continue;
                    history.add(commit);
                    continue;
                }
                catch (Exception e) {
                    throw new MicroKernelException((Throwable)e);
                }
            }
            history.add(commit);
        }
        JsopBuilder buff = new JsopBuilder().array();
        for (MongoCommit commit : history) {
            buff.object().key("id").value(MongoUtil.fromMongoRepresentation(commit.getRevisionId())).key("ts").value(commit.getTimestamp().longValue()).key("msg").value(commit.getMessage()).endObject();
        }
        return buff.endArray().toString();
    }

    private Node getNode(String path, long revisionId) throws Exception {
        return new GetNodesCommandNew(this.nodeStore, path, revisionId).execute();
    }
}

