/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.mongomk.impl.command;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.jackrabbit.mongomk.api.model.Node;
import org.apache.jackrabbit.mongomk.impl.MongoNodeStore;
import org.apache.jackrabbit.mongomk.impl.action.FetchNodesActionNew;
import org.apache.jackrabbit.mongomk.impl.command.BaseCommand;
import org.apache.jackrabbit.mongomk.impl.command.GetHeadRevisionCommand;
import org.apache.jackrabbit.mongomk.impl.command.exception.InconsistentNodeHierarchyException;
import org.apache.jackrabbit.mongomk.impl.model.MongoNode;
import org.apache.jackrabbit.mongomk.impl.model.NodeImpl;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetNodesCommandNew
extends BaseCommand<Node> {
    private static final Logger LOG = LoggerFactory.getLogger(GetNodesCommandNew.class);
    private final String path;
    private String branchId;
    private int depth = -1;
    private Long revisionId;
    private Map<String, MongoNode> pathAndNodeMap;
    private Node rootNode;

    public GetNodesCommandNew(MongoNodeStore nodeStore, String path, Long revisionId) {
        super(nodeStore);
        this.path = path;
        this.revisionId = revisionId;
    }

    public void setBranchId(String branchId) {
        this.branchId = branchId;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    @Override
    public Node execute() throws Exception {
        if (this.revisionId == null) {
            this.revisionId = new GetHeadRevisionCommand(this.nodeStore).execute();
        }
        this.readRootNode();
        return this.rootNode;
    }

    private void readRootNode() throws InconsistentNodeHierarchyException {
        this.readNodesByPath();
        boolean verified = this.verifyNodeHierarchy();
        if (!verified) {
            throw new InconsistentNodeHierarchyException();
        }
        this.buildNodeStructure();
    }

    @Override
    public int getNumOfRetries() {
        return 3;
    }

    @Override
    public boolean needsRetry(Exception e) {
        return e instanceof InconsistentNodeHierarchyException;
    }

    private void buildNodeStructure() {
        MongoNode nodeMongoRootOfPath = this.pathAndNodeMap.get(this.path);
        this.rootNode = this.buildNodeStructure(nodeMongoRootOfPath);
    }

    private NodeImpl buildNodeStructure(MongoNode nodeMongo) {
        if (nodeMongo == null) {
            return null;
        }
        NodeImpl node = MongoNode.toNode(nodeMongo);
        Iterator<Node> it = node.getChildNodeEntries(0, -1);
        while (it.hasNext()) {
            Node child = it.next();
            MongoNode nodeMongoChild = this.pathAndNodeMap.get(child.getPath());
            if (nodeMongoChild == null) continue;
            NodeImpl nodeChild = this.buildNodeStructure(nodeMongoChild);
            node.addChildNodeEntry(nodeChild);
        }
        return node;
    }

    private void readNodesByPath() {
        FetchNodesActionNew query = new FetchNodesActionNew(this.nodeStore, this.path, this.depth, this.revisionId);
        query.setBranchId(this.branchId);
        this.pathAndNodeMap = query.execute();
    }

    private boolean verifyNodeHierarchy() {
        boolean verified = this.verifyNodeHierarchyRec(this.path, 0);
        if (!verified) {
            LOG.error("Node hierarchy could not be verified because some nodes were inconsistent: {}", (Object)this.path);
        }
        return verified;
    }

    private boolean verifyNodeHierarchyRec(String path, int currentDepth) {
        boolean verified;
        block3: {
            List<String> childNames;
            verified = false;
            if (this.pathAndNodeMap.isEmpty()) {
                return true;
            }
            MongoNode nodeMongo = this.pathAndNodeMap.get(path);
            if (nodeMongo == null) break block3;
            verified = true;
            if ((this.depth == -1 || currentDepth < this.depth) && (childNames = nodeMongo.getChildren()) != null) {
                String childName;
                String childPath;
                Iterator<String> i$ = childNames.iterator();
                while (i$.hasNext() && (verified = this.verifyNodeHierarchyRec(childPath = PathUtils.concat((String)path, (String)(childName = i$.next())), ++currentDepth))) {
                }
            }
        }
        return verified;
    }
}

