/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.mongomk.impl.command;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.SortedSet;
import org.apache.jackrabbit.mongomk.api.model.Node;
import org.apache.jackrabbit.mongomk.impl.MongoNodeStore;
import org.apache.jackrabbit.mongomk.impl.action.FetchCommitsAction;
import org.apache.jackrabbit.mongomk.impl.action.FetchNodesAction;
import org.apache.jackrabbit.mongomk.impl.command.BaseCommand;
import org.apache.jackrabbit.mongomk.impl.command.GetHeadRevisionCommand;
import org.apache.jackrabbit.mongomk.impl.command.exception.InconsistentNodeHierarchyException;
import org.apache.jackrabbit.mongomk.impl.model.MongoCommit;
import org.apache.jackrabbit.mongomk.impl.model.MongoNode;
import org.apache.jackrabbit.mongomk.impl.model.NodeImpl;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetNodesCommand
extends BaseCommand<Node> {
    private static final Logger LOG = LoggerFactory.getLogger(GetNodesCommand.class);
    private final String path;
    private String branchId;
    private int depth = -1;
    private Long revisionId;
    private List<MongoCommit> lastCommits;
    private Map<String, MongoNode> pathAndNodeMap;
    private Map<String, Long> problematicNodes;
    private Node rootNode;

    public GetNodesCommand(MongoNodeStore nodeStore, String path, Long revisionId) {
        super(nodeStore);
        this.path = path;
        this.revisionId = revisionId;
    }

    public void setBranchId(String branchId) {
        this.branchId = branchId;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    @Override
    public Node execute() throws Exception {
        this.readLastCommits();
        this.deriveProblematicNodes();
        this.readRootNode();
        return this.rootNode;
    }

    private void readRootNode() throws InconsistentNodeHierarchyException {
        boolean verified;
        this.readNodesByPath();
        boolean bl = verified = this.verifyProblematicNodes() && this.verifyNodeHierarchy();
        if (!verified) {
            throw new InconsistentNodeHierarchyException();
        }
        this.buildNodeStructure();
    }

    @Override
    public int getNumOfRetries() {
        return 3;
    }

    @Override
    public boolean needsRetry(Exception e) {
        return e instanceof InconsistentNodeHierarchyException;
    }

    private void buildNodeStructure() {
        MongoNode nodeMongoRootOfPath = this.pathAndNodeMap.get(this.path);
        this.rootNode = this.buildNodeStructure(nodeMongoRootOfPath);
    }

    private NodeImpl buildNodeStructure(MongoNode nodeMongo) {
        if (nodeMongo == null) {
            return null;
        }
        NodeImpl node = MongoNode.toNode(nodeMongo);
        Iterator<Node> it = node.getChildNodeEntries(0, -1);
        while (it.hasNext()) {
            Node child = it.next();
            MongoNode nodeMongoChild = this.pathAndNodeMap.get(child.getPath());
            if (nodeMongoChild == null) continue;
            NodeImpl nodeChild = this.buildNodeStructure(nodeMongoChild);
            node.addChildNodeEntry(nodeChild);
        }
        return node;
    }

    private void deriveProblematicNodes() {
        this.problematicNodes = new HashMap<String, Long>();
        ListIterator<MongoCommit> iterator = this.lastCommits.listIterator();
        while (iterator.hasPrevious()) {
            MongoCommit commitMongo = iterator.previous();
            long revisionId = commitMongo.getRevisionId();
            SortedSet<String> affectedPaths = commitMongo.getAffectedPaths();
            for (String path : affectedPaths) {
                this.problematicNodes.put(path, revisionId);
            }
        }
    }

    private void readLastCommits() throws Exception {
        if (this.revisionId == null) {
            this.revisionId = new GetHeadRevisionCommand(this.nodeStore).execute();
        }
        boolean commitExists = false;
        this.lastCommits = new FetchCommitsAction(this.nodeStore, this.revisionId).execute();
        for (MongoCommit commit : this.lastCommits) {
            if (!commit.getRevisionId().equals(this.revisionId)) continue;
            commitExists = true;
            break;
        }
        if (!commitExists) {
            throw new Exception(String.format("Commit with revision %d could not be found", this.revisionId));
        }
    }

    private void readNodesByPath() {
        FetchNodesAction query = new FetchNodesAction(this.nodeStore, this.path, (long)this.revisionId);
        query.setBranchId(this.branchId);
        query.setValidCommits(this.lastCommits);
        query.setDepth(this.depth);
        this.pathAndNodeMap = query.execute();
    }

    private boolean verifyNodeHierarchy() {
        boolean verified = this.verifyNodeHierarchyRec(this.path, 0);
        if (!verified) {
            LOG.error("Node hierarchy could not be verified because some nodes were inconsistent: {}", (Object)this.path);
        }
        return verified;
    }

    private boolean verifyNodeHierarchyRec(String path, int currentDepth) {
        boolean verified;
        block3: {
            List<String> childNames;
            verified = false;
            if (this.pathAndNodeMap.isEmpty()) {
                return true;
            }
            MongoNode nodeMongo = this.pathAndNodeMap.get(path);
            if (nodeMongo == null) break block3;
            verified = true;
            if ((this.depth == -1 || currentDepth < this.depth) && (childNames = nodeMongo.getChildren()) != null) {
                String childName;
                String childPath;
                Iterator<String> i$ = childNames.iterator();
                while (i$.hasNext() && (verified = this.verifyNodeHierarchyRec(childPath = PathUtils.concat((String)path, (String)(childName = i$.next())), ++currentDepth))) {
                }
            }
        }
        return verified;
    }

    private boolean verifyProblematicNodes() {
        for (Map.Entry<String, Long> entry : this.problematicNodes.entrySet()) {
            String path = entry.getKey();
            Long revisionId = entry.getValue();
            MongoNode nodeMongo = this.pathAndNodeMap.get(path);
            if (nodeMongo == null || revisionId.equals(nodeMongo.getRevisionId())) continue;
            LOG.error("Node could not be verified because revisionIds did not match: {} (expected) vs {} (actual)", (Object)revisionId, (Object)nodeMongo.getRevisionId());
            return false;
        }
        return true;
    }
}

