/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.mongomk.impl.command;

import java.util.List;
import org.apache.jackrabbit.mk.api.MicroKernelException;
import org.apache.jackrabbit.mk.json.JsopBuilder;
import org.apache.jackrabbit.mk.model.tree.DiffBuilder;
import org.apache.jackrabbit.mongomk.api.model.Node;
import org.apache.jackrabbit.mongomk.impl.MongoNodeStore;
import org.apache.jackrabbit.mongomk.impl.action.FetchCommitsAction;
import org.apache.jackrabbit.mongomk.impl.action.FetchHeadRevisionIdAction;
import org.apache.jackrabbit.mongomk.impl.command.BaseCommand;
import org.apache.jackrabbit.mongomk.impl.command.GetNodesCommandNew;
import org.apache.jackrabbit.mongomk.impl.model.MongoCommit;
import org.apache.jackrabbit.mongomk.impl.model.tree.SimpleMongoNodeStore;
import org.apache.jackrabbit.mongomk.util.MongoUtil;

public class GetJournalCommand
extends BaseCommand<String> {
    private final String fromRevisionId;
    private final String toRevisionId;
    private String path;

    public GetJournalCommand(MongoNodeStore nodeStore, String fromRevisionId, String toRevisionId, String path) {
        super(nodeStore);
        this.fromRevisionId = fromRevisionId;
        this.toRevisionId = toRevisionId;
        this.path = path;
    }

    @Override
    public String execute() throws Exception {
        this.path = MongoUtil.adjustPath(this.path);
        long fromRevision = MongoUtil.toMongoRepresentation(this.fromRevisionId);
        long toRevision = this.toRevisionId == null ? new FetchHeadRevisionIdAction(this.nodeStore).execute().longValue() : MongoUtil.toMongoRepresentation(this.toRevisionId).longValue();
        List<MongoCommit> commits = this.getCommits(fromRevision, toRevision);
        MongoCommit toCommit = this.extractCommit(commits, toRevision);
        MongoCommit fromCommit = toRevision == fromRevision ? toCommit : this.extractCommit(commits, fromRevision);
        if (fromCommit != null && fromCommit.getBranchId() != null && !fromCommit.getBranchId().equals(toCommit.getBranchId())) {
            throw new MicroKernelException("Inconsistent range specified: fromRevision denotes a private branch while toRevision denotes a head or another private branch");
        }
        if (fromCommit != null && fromCommit.getTimestamp() > toCommit.getTimestamp()) {
            return "[]";
        }
        JsopBuilder commitBuff = new JsopBuilder().array();
        for (int i = commits.size() - 1; i >= 0; --i) {
            MongoCommit commit = commits.get(i);
            String diff = commit.getDiff();
            if (MongoUtil.isFiltered(this.path)) {
                try {
                    diff = new DiffBuilder(MongoUtil.wrap(this.getNode("/", commit.getBaseRevisionId())), MongoUtil.wrap(this.getNode("/", commit.getRevisionId())), "/", -1, new SimpleMongoNodeStore(), this.path).build();
                    if (diff.isEmpty()) {
                        continue;
                    }
                }
                catch (Exception e) {
                    throw new MicroKernelException((Throwable)e);
                }
            }
            commitBuff.object().key("id").value(MongoUtil.fromMongoRepresentation(commit.getRevisionId())).key("ts").value(commit.getTimestamp().longValue()).key("msg").value(commit.getMessage());
            if (commit.getBranchId() != null) {
                commitBuff.key("branchRootId").value(commit.getBranchId().toString());
            }
            commitBuff.key("changes").value(diff).endObject();
        }
        return commitBuff.endArray().toString();
    }

    private MongoCommit extractCommit(List<MongoCommit> commits, long revisionId) {
        for (MongoCommit commit : commits) {
            if (commit.getRevisionId() != revisionId) continue;
            return commit;
        }
        return null;
    }

    private List<MongoCommit> getCommits(long fromRevisionId, long toRevisionId) {
        return new FetchCommitsAction(this.nodeStore, fromRevisionId, toRevisionId).execute();
    }

    private Node getNode(String path, long revisionId) throws Exception {
        return new GetNodesCommandNew(this.nodeStore, path, revisionId).execute();
    }
}

