/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.mongomk.impl.command;

import org.apache.jackrabbit.mk.model.tree.DiffBuilder;
import org.apache.jackrabbit.mk.model.tree.NodeState;
import org.apache.jackrabbit.mongomk.api.model.Node;
import org.apache.jackrabbit.mongomk.impl.MongoNodeStore;
import org.apache.jackrabbit.mongomk.impl.action.FetchCommitAction;
import org.apache.jackrabbit.mongomk.impl.action.FetchHeadRevisionIdAction;
import org.apache.jackrabbit.mongomk.impl.command.BaseCommand;
import org.apache.jackrabbit.mongomk.impl.command.GetNodesCommandNew;
import org.apache.jackrabbit.mongomk.impl.model.MongoCommit;
import org.apache.jackrabbit.mongomk.impl.model.tree.SimpleMongoNodeStore;
import org.apache.jackrabbit.mongomk.util.MongoUtil;

public class DiffCommand
extends BaseCommand<String> {
    private final String fromRevision;
    private final String toRevision;
    private final int depth;
    private String path;

    public DiffCommand(MongoNodeStore nodeStore, String fromRevision, String toRevision, String path, int depth) {
        super(nodeStore);
        this.fromRevision = fromRevision;
        this.toRevision = toRevision;
        this.path = path;
        this.depth = depth;
    }

    @Override
    public String execute() throws Exception {
        MongoCommit toCommit;
        long toRevisionId;
        long fromRevisionId;
        this.path = MongoUtil.adjustPath(this.path);
        this.checkDepth();
        if (this.fromRevision == null || this.toRevision == null) {
            long head = new FetchHeadRevisionIdAction(this.nodeStore).execute();
            fromRevisionId = this.fromRevision == null ? head : MongoUtil.toMongoRepresentation(this.fromRevision);
            toRevisionId = this.toRevision == null ? head : MongoUtil.toMongoRepresentation(this.toRevision);
        } else {
            fromRevisionId = MongoUtil.toMongoRepresentation(this.fromRevision);
            toRevisionId = MongoUtil.toMongoRepresentation(this.toRevision);
        }
        if (fromRevisionId == toRevisionId) {
            return "";
        }
        if ("/".equals(this.path) && (toCommit = new FetchCommitAction(this.nodeStore, toRevisionId).execute()).getBaseRevisionId() == fromRevisionId) {
            return toCommit.getDiff();
        }
        NodeState beforeState = MongoUtil.wrap(this.getNode(this.path, fromRevisionId));
        NodeState afterState = MongoUtil.wrap(this.getNode(this.path, toRevisionId));
        return new DiffBuilder(beforeState, afterState, this.path, this.depth, new SimpleMongoNodeStore(), this.path).build();
    }

    private void checkDepth() {
        if (this.depth < -1) {
            throw new IllegalArgumentException("depth");
        }
    }

    private Node getNode(String path, long revisionId) throws Exception {
        GetNodesCommandNew command = new GetNodesCommandNew(this.nodeStore, path, revisionId);
        return command.execute();
    }
}

