/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.mongomk.impl.command;

import org.apache.jackrabbit.mongomk.api.command.Command;
import org.apache.jackrabbit.mongomk.api.command.CommandExecutor;

public class DefaultCommandExecutor
implements CommandExecutor {
    @Override
    public <T> T execute(Command<T> command) throws Exception {
        Object result = null;
        int numOfRetries = command.getNumOfRetries();
        boolean needsRetry = true;
        for (int currentRetry = 0; currentRetry <= numOfRetries && needsRetry; ++currentRetry) {
            try {
                result = command.execute();
                needsRetry = command.needsRetry(result);
                continue;
            }
            catch (Exception e) {
                needsRetry = command.needsRetry(e);
                if (needsRetry && currentRetry < numOfRetries) continue;
                throw e;
            }
        }
        return result;
    }
}

