/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.mongomk.impl.command;

import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.QueryBuilder;
import com.mongodb.WriteConcern;
import com.mongodb.WriteResult;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.jackrabbit.mongomk.api.instruction.Instruction;
import org.apache.jackrabbit.mongomk.api.model.Commit;
import org.apache.jackrabbit.mongomk.impl.MongoNodeStore;
import org.apache.jackrabbit.mongomk.impl.action.FetchCommitAction;
import org.apache.jackrabbit.mongomk.impl.action.FetchHeadRevisionIdAction;
import org.apache.jackrabbit.mongomk.impl.action.ReadAndIncHeadRevisionAction;
import org.apache.jackrabbit.mongomk.impl.action.SaveAndSetHeadRevisionAction;
import org.apache.jackrabbit.mongomk.impl.action.SaveCommitAction;
import org.apache.jackrabbit.mongomk.impl.action.SaveNodesAction;
import org.apache.jackrabbit.mongomk.impl.command.BaseCommand;
import org.apache.jackrabbit.mongomk.impl.command.NodeExistsCommand;
import org.apache.jackrabbit.mongomk.impl.command.exception.ConflictingCommitException;
import org.apache.jackrabbit.mongomk.impl.instruction.CommitCommandInstructionVisitor;
import org.apache.jackrabbit.mongomk.impl.model.MongoCommit;
import org.apache.jackrabbit.mongomk.impl.model.MongoNode;
import org.apache.jackrabbit.mongomk.impl.model.MongoSync;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommitCommandNew
extends BaseCommand<Long> {
    private static final Logger logger = LoggerFactory.getLogger(CommitCommandNew.class);
    private final MongoCommit commit;
    private Set<String> affectedPaths;
    private Map<String, MongoNode> existingNodes;
    private MongoSync mongoSync;
    private Map<String, MongoNode> nodes;
    private Long revisionId;
    private final Long initialBaseRevisionId;
    private Long baseRevisionId;
    private String branchId;

    public CommitCommandNew(MongoNodeStore nodeStore, Commit commit) {
        super(nodeStore);
        this.commit = (MongoCommit)commit;
        this.initialBaseRevisionId = commit.getBaseRevisionId();
    }

    @Override
    public Long execute() throws Exception {
        int retries = 0;
        boolean success = false;
        do {
            this.mongoSync = new ReadAndIncHeadRevisionAction(this.nodeStore).execute();
            this.revisionId = this.mongoSync.getNextRevisionId() - 1L;
            this.baseRevisionId = this.initialBaseRevisionId != null ? this.initialBaseRevisionId : Long.valueOf(this.mongoSync.getHeadRevisionId());
            logger.debug("Committing @{} with diff: {}", (Object)this.revisionId, (Object)this.commit.getDiff());
            this.readBranchIdFromBaseCommit();
            this.createMongoNodes();
            this.prepareCommit();
            FetchHeadRevisionIdAction action = new FetchHeadRevisionIdAction(this.nodeStore, this.branchId);
            long headRevisionId = action.execute();
            if (this.baseRevisionId < headRevisionId) {
                this.readExistingNodes();
                this.mergeNodes();
            }
            this.prepareMongoNodes();
            new SaveNodesAction(this.nodeStore, this.nodes.values()).execute();
            new SaveCommitAction(this.nodeStore, this.commit).execute();
            success = this.saveAndSetHeadRevision();
            if (success) {
                this.cacheNodes();
                continue;
            }
            ++retries;
        } while (!success);
        String msg = "Commit @{}: success";
        if (retries > 0) {
            msg = msg + " with {} retries.";
        }
        logger.debug(msg, (Object)this.revisionId, (Object)retries);
        return this.revisionId;
    }

    @Override
    public int getNumOfRetries() {
        return 100;
    }

    @Override
    public boolean needsRetry(Exception e) {
        return e instanceof ConflictingCommitException;
    }

    private void readBranchIdFromBaseCommit() throws Exception {
        String commitBranchId = this.commit.getBranchId();
        if (commitBranchId != null) {
            this.branchId = commitBranchId;
            return;
        }
        Long baseRevisionId = this.commit.getBaseRevisionId();
        if (baseRevisionId == null) {
            return;
        }
        FetchCommitAction action = new FetchCommitAction(this.nodeStore, baseRevisionId);
        MongoCommit commit = action.execute();
        this.branchId = commit.getBranchId();
    }

    private void createMongoNodes() throws Exception {
        CommitCommandInstructionVisitor visitor = new CommitCommandInstructionVisitor(this.nodeStore, this.baseRevisionId, null);
        visitor.setBranchId(this.branchId);
        for (Instruction instruction : this.commit.getInstructions()) {
            instruction.accept(visitor);
        }
        this.nodes = visitor.getPathNodeMap();
        this.affectedPaths = this.nodes.keySet();
    }

    private void prepareCommit() throws Exception {
        this.commit.setAffectedPaths(this.affectedPaths);
        this.commit.setBaseRevisionId(this.branchId == null ? this.mongoSync.getHeadRevisionId() : this.baseRevisionId.longValue());
        this.commit.setRevisionId(this.revisionId);
        if (this.commit.getBranchId() == null && this.branchId != null) {
            this.commit.setBranchId(this.branchId);
        }
        this.commit.removeField("_id");
    }

    private void readExistingNodes() throws Exception {
        if (this.affectedPaths == null || this.affectedPaths.isEmpty()) {
            this.existingNodes = Collections.emptyMap();
        }
        this.existingNodes = new HashMap<String, MongoNode>();
        for (String path : this.affectedPaths) {
            NodeExistsCommand command;
            if (this.branchId == null) {
                command = new NodeExistsCommand(this.nodeStore, path, this.mongoSync.getHeadRevisionId());
            } else {
                command = new NodeExistsCommand(this.nodeStore, path, this.baseRevisionId);
                command.setBranchId(this.branchId);
            }
            if (!command.execute().booleanValue()) continue;
            this.existingNodes.put(path, command.getNode());
        }
    }

    private void mergeNodes() {
        for (MongoNode committingNode : this.nodes.values()) {
            List<String> existingChildren;
            Map<String, Object> existingProperties;
            MongoNode existingNode = this.existingNodes.get(committingNode.getPath());
            if (existingNode == null) continue;
            if (logger.isDebugEnabled()) {
                logger.debug("Found existing node to merge: {}", (Object)existingNode.getPath());
                logger.debug("Existing node: {}", (Object)existingNode);
                logger.debug("Committing node: {}", (Object)committingNode);
            }
            if (!(existingProperties = existingNode.getProperties()).isEmpty()) {
                committingNode.setProperties(existingProperties);
                logger.debug("Merged properties for {}: {}", (Object)existingNode.getPath(), existingProperties);
            }
            if ((existingChildren = existingNode.getChildren()) != null) {
                committingNode.setChildren(existingChildren);
                logger.debug("Merged children for {}: {}", (Object)existingNode.getPath(), existingChildren);
            }
            logger.debug("Merged node for {}: {}", (Object)existingNode.getPath(), (Object)committingNode);
        }
    }

    private void prepareMongoNodes() {
        for (MongoNode committingNode : this.nodes.values()) {
            Map<String, Object> removedProperties;
            List<String> removedChildren;
            logger.debug("Preparing children (added and removed) of {}", (Object)committingNode.getPath());
            logger.debug("Committing node: {}", (Object)committingNode);
            AbstractList children = committingNode.getChildren();
            children = children == null ? new LinkedList<String>() : new ArrayList<String>(children);
            List<String> addedChildren = committingNode.getAddedChildren();
            if (addedChildren != null) {
                children.addAll(addedChildren);
            }
            if ((removedChildren = committingNode.getRemovedChildren()) != null) {
                children.removeAll(removedChildren);
            }
            if (!children.isEmpty()) {
                HashSet<String> temp = new HashSet<String>(children);
                committingNode.setChildren(new LinkedList<String>(temp));
            } else {
                committingNode.setChildren(null);
            }
            Map<String, Object> properties = committingNode.getProperties();
            Map<String, Object> addedProperties = committingNode.getAddedProps();
            if (addedProperties != null) {
                properties.putAll(addedProperties);
            }
            if ((removedProperties = committingNode.getRemovedProps()) != null) {
                for (Map.Entry<String, Object> entry : removedProperties.entrySet()) {
                    properties.remove(entry.getKey());
                }
            }
            if (!properties.isEmpty()) {
                committingNode.setProperties(properties);
            } else {
                committingNode.setProperties(null);
            }
            committingNode.setRevisionId(this.revisionId);
            if (this.branchId != null) {
                committingNode.setBranchId(this.branchId);
            }
            logger.debug("Prepared committing node: {}", (Object)committingNode);
        }
    }

    protected boolean saveAndSetHeadRevision() throws Exception {
        if (this.branchId != null) {
            return true;
        }
        long assumedHeadRevision = this.mongoSync.getHeadRevisionId();
        MongoSync mongoSync = new SaveAndSetHeadRevisionAction(this.nodeStore, assumedHeadRevision, this.revisionId).execute();
        if (mongoSync == null) {
            if (this.conflictingCommitsExist(assumedHeadRevision)) {
                String message = String.format("Commit @%s: failed due to a conflicting commit. Affected paths: %s", this.revisionId, this.commit.getAffectedPaths());
                logger.warn(message);
                this.markAsFailed();
                throw new ConflictingCommitException(message);
            }
            logger.info("Commit @{}: failed due to a concurrent commit. Affected paths: {}", (Object)this.revisionId, this.commit.getAffectedPaths());
            this.markAsFailed();
            return false;
        }
        return true;
    }

    private boolean conflictingCommitsExist(long baseRevisionId) {
        QueryBuilder queryBuilder = QueryBuilder.start((String)"failed").notEquals((Object)Boolean.TRUE).and("baseRevId").is((Object)baseRevisionId).and("revId").greaterThan((Object)0L).and("revId").notEquals((Object)this.revisionId);
        DBObject query = queryBuilder.get();
        DBCollection collection = this.nodeStore.getCommitCollection();
        MongoCommit conflictingCommit = (MongoCommit)collection.findOne(query);
        for (String affectedPath : conflictingCommit.getAffectedPaths()) {
            if (!this.affectedPaths.contains(affectedPath)) continue;
            return true;
        }
        return false;
    }

    private void markAsFailed() throws Exception {
        DBCollection commitCollection = this.nodeStore.getCommitCollection();
        DBObject query = QueryBuilder.start((String)"_id").is((Object)this.commit.getObjectId("_id")).get();
        BasicDBObject update = new BasicDBObject("$set", (Object)new BasicDBObject("failed", (Object)Boolean.TRUE));
        WriteResult writeResult = commitCollection.update(query, (DBObject)update, false, false, WriteConcern.SAFE);
        this.nodeStore.evict(this.commit);
        if (writeResult.getError() != null) {
            throw new Exception(String.format("Update wasn't successful: %s", writeResult));
        }
    }

    private void cacheNodes() {
        for (MongoNode node : this.nodes.values()) {
            this.nodeStore.cache(node);
        }
    }
}

