/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.mongomk.impl.blob;

import com.mongodb.DB;
import com.mongodb.gridfs.GridFS;
import java.io.InputStream;
import org.apache.jackrabbit.mk.blobs.BlobStore;
import org.apache.jackrabbit.mongomk.api.command.CommandExecutor;
import org.apache.jackrabbit.mongomk.impl.command.DefaultCommandExecutor;
import org.apache.jackrabbit.mongomk.impl.command.blob.GetBlobLengthCommandGridFS;
import org.apache.jackrabbit.mongomk.impl.command.blob.ReadBlobCommandGridFS;
import org.apache.jackrabbit.mongomk.impl.command.blob.WriteBlobCommandGridFS;

public class MongoGridFSBlobStore
implements BlobStore {
    private final CommandExecutor commandExecutor = new DefaultCommandExecutor();
    private final GridFS gridFS;

    public MongoGridFSBlobStore(DB db) {
        this.gridFS = new GridFS(db);
    }

    public long getBlobLength(String blobId) throws Exception {
        GetBlobLengthCommandGridFS command = new GetBlobLengthCommandGridFS(this.gridFS, blobId);
        return this.commandExecutor.execute(command);
    }

    public int readBlob(String blobId, long blobOffset, byte[] buffer, int bufferOffset, int length) throws Exception {
        ReadBlobCommandGridFS command = new ReadBlobCommandGridFS(this.gridFS, blobId, blobOffset, buffer, bufferOffset, length);
        return this.commandExecutor.execute(command);
    }

    public String writeBlob(InputStream is) throws Exception {
        WriteBlobCommandGridFS command = new WriteBlobCommandGridFS(this.gridFS, is);
        return this.commandExecutor.execute(command);
    }
}

