/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.mongomk.impl.blob;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.QueryBuilder;
import com.mongodb.WriteResult;
import org.apache.jackrabbit.mk.blobs.AbstractBlobStore;
import org.apache.jackrabbit.mk.util.StringUtils;
import org.apache.jackrabbit.mongomk.impl.model.MongoBlob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoBlobStore
extends AbstractBlobStore {
    public static final String COLLECTION_BLOBS = "blobs";
    private static final Logger LOG = LoggerFactory.getLogger(MongoBlobStore.class);
    private final DB db;
    private long minLastModified;

    public MongoBlobStore(DB db) {
        this.db = db;
        this.initBlobCollection();
    }

    protected void storeBlock(byte[] digest, int level, byte[] data) throws Exception {
        String id = StringUtils.convertBytesToHex((byte[])digest);
        MongoBlob mongoBlob = new MongoBlob();
        mongoBlob.setId(id);
        mongoBlob.setData(data);
        mongoBlob.setLevel(level);
        mongoBlob.setLastMod(System.currentTimeMillis());
        this.getBlobCollection().insert(new DBObject[]{mongoBlob});
    }

    protected byte[] readBlockFromBackend(AbstractBlobStore.BlockId blockId) throws Exception {
        String id = StringUtils.convertBytesToHex((byte[])blockId.getDigest());
        MongoBlob blobMongo = this.getBlob(id, 0L);
        byte[] data = blobMongo.getData();
        if (blockId.getPos() == 0L) {
            return data;
        }
        int len = (int)((long)data.length - blockId.getPos());
        if (len < 0) {
            return new byte[0];
        }
        byte[] d2 = new byte[len];
        System.arraycopy(data, (int)blockId.getPos(), d2, 0, len);
        return d2;
    }

    public void startMark() throws Exception {
        this.minLastModified = System.currentTimeMillis();
        this.markInUse();
    }

    protected boolean isMarkEnabled() {
        return this.minLastModified != 0L;
    }

    protected void mark(AbstractBlobStore.BlockId blockId) throws Exception {
        if (this.minLastModified == 0L) {
            return;
        }
        String id = StringUtils.convertBytesToHex((byte[])blockId.getDigest());
        DBObject query = this.getBlobQuery(id, this.minLastModified);
        BasicDBObject update = new BasicDBObject("$set", (Object)new BasicDBObject("lastMod", (Object)System.currentTimeMillis()));
        WriteResult writeResult = this.getBlobCollection().update(query, (DBObject)update);
        if (writeResult.getError() != null) {
            LOG.error("Mark failed for blob %s: %s", (Object)id, (Object)writeResult.getError());
        }
    }

    public int sweep() throws Exception {
        DBObject query = this.getBlobQuery(null, this.minLastModified);
        long countBefore = this.getBlobCollection().count(query);
        WriteResult writeResult = this.getBlobCollection().remove(query);
        if (writeResult.getError() != null) {
            LOG.error("Sweep failed: %s", (Object)writeResult.getError());
        }
        long countAfter = this.getBlobCollection().count(query);
        this.minLastModified = 0L;
        return (int)(countBefore - countAfter);
    }

    private DBCollection getBlobCollection() {
        DBCollection collection = this.db.getCollection(COLLECTION_BLOBS);
        collection.setObjectClass(MongoBlob.class);
        return collection;
    }

    private void initBlobCollection() {
        if (this.db.collectionExists(COLLECTION_BLOBS)) {
            return;
        }
        DBCollection collection = this.getBlobCollection();
        BasicDBObject index = new BasicDBObject();
        index.put("_id", (Object)1L);
        BasicDBObject options = new BasicDBObject();
        options.put("unique", (Object)Boolean.TRUE);
        collection.ensureIndex((DBObject)index, (DBObject)options);
    }

    private MongoBlob getBlob(String id, long lastMod) {
        DBObject query = this.getBlobQuery(id, lastMod);
        return (MongoBlob)this.getBlobCollection().findOne(query);
    }

    private DBObject getBlobQuery(String id, long lastMod) {
        QueryBuilder queryBuilder = new QueryBuilder();
        if (id != null) {
            queryBuilder = queryBuilder.and("_id").is((Object)id);
        }
        if (lastMod > 0L) {
            queryBuilder = queryBuilder.and("lastMod").lessThan((Object)lastMod);
        }
        return queryBuilder.get();
    }
}

