/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.mongomk.impl.action;

import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.QueryBuilder;
import org.apache.jackrabbit.mongomk.impl.MongoNodeStore;
import org.apache.jackrabbit.mongomk.impl.action.BaseAction;
import org.apache.jackrabbit.mongomk.impl.model.MongoSync;

public class SaveAndSetHeadRevisionAction
extends BaseAction<MongoSync> {
    private final long newHeadRevision;
    private final long oldHeadRevision;

    public SaveAndSetHeadRevisionAction(MongoNodeStore nodeStore, long oldHeadRevision, long newHeadRevision) {
        super(nodeStore);
        this.oldHeadRevision = oldHeadRevision;
        this.newHeadRevision = newHeadRevision;
    }

    @Override
    public MongoSync execute() throws Exception {
        DBObject query = QueryBuilder.start((String)"headRevId").is((Object)this.oldHeadRevision).get();
        BasicDBObject update = new BasicDBObject("$set", (Object)new BasicDBObject("headRevId", (Object)this.newHeadRevision));
        DBCollection collection = this.nodeStore.getSyncCollection();
        DBObject dbObject = collection.findAndModify(query, null, null, false, (DBObject)update, true, false);
        return MongoSync.fromDBObject(dbObject);
    }
}

