/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.mongomk.impl.action;

import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.QueryBuilder;
import org.apache.jackrabbit.mongomk.impl.MongoNodeStore;
import org.apache.jackrabbit.mongomk.impl.action.BaseAction;
import org.apache.jackrabbit.mongomk.impl.model.MongoCommit;
import org.apache.jackrabbit.mongomk.impl.model.MongoSync;

public class FetchHeadRevisionIdAction
extends BaseAction<Long> {
    private final String branchId;

    public FetchHeadRevisionIdAction(MongoNodeStore nodeStore) {
        this(nodeStore, null);
    }

    public FetchHeadRevisionIdAction(MongoNodeStore nodeStore, String branchId) {
        super(nodeStore);
        this.branchId = branchId;
    }

    @Override
    public Long execute() throws Exception {
        DBCollection headCollection = this.nodeStore.getSyncCollection();
        MongoSync syncMongo = (MongoSync)headCollection.findOne();
        long headRevisionId = syncMongo.getHeadRevisionId();
        DBCollection collection = this.nodeStore.getCommitCollection();
        QueryBuilder qb = QueryBuilder.start((String)"failed").notEquals((Object)Boolean.TRUE).and("revId").lessThanEquals((Object)headRevisionId);
        qb = this.branchId == null ? qb.and(new DBObject[]{new BasicDBObject("branchId", (Object)new BasicDBObject("$exists", (Object)false))}) : qb.and("branchId").is((Object)this.branchId);
        DBObject query = qb.get();
        BasicDBObject fields = new BasicDBObject("revId", (Object)1);
        BasicDBObject orderBy = new BasicDBObject("revId", (Object)-1);
        MongoCommit commit = (MongoCommit)collection.findOne(query, (DBObject)fields, (DBObject)orderBy);
        return commit != null ? commit.getRevisionId() : headRevisionId;
    }
}

