/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.mongomk.impl.action;

import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.QueryBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.jackrabbit.mongomk.impl.MongoNodeStore;
import org.apache.jackrabbit.mongomk.impl.action.BaseAction;
import org.apache.jackrabbit.mongomk.impl.model.MongoCommit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FetchCommitsAction
extends BaseAction<List<MongoCommit>> {
    private static final int LIMITLESS = -1;
    private static final Logger LOG = LoggerFactory.getLogger(FetchCommitsAction.class);
    private long fromRevisionId = -1L;
    private long toRevisionId = -1L;
    private int maxEntries = -1;
    private boolean includeBranchCommits = true;

    public FetchCommitsAction(MongoNodeStore nodeStore) {
        this(nodeStore, -1L, -1L);
    }

    public FetchCommitsAction(MongoNodeStore nodeStore, long toRevisionId) {
        this(nodeStore, -1L, toRevisionId);
    }

    public FetchCommitsAction(MongoNodeStore nodeStore, long fromRevisionId, long toRevisionId) {
        super(nodeStore);
        this.fromRevisionId = fromRevisionId;
        this.toRevisionId = toRevisionId;
    }

    public FetchCommitsAction setMaxEntries(int maxEntries) {
        this.maxEntries = maxEntries;
        return this;
    }

    public FetchCommitsAction includeBranchCommits(boolean includeBranchCommits) {
        this.includeBranchCommits = includeBranchCommits;
        return this;
    }

    @Override
    public List<MongoCommit> execute() {
        if (this.maxEntries == 0) {
            return Collections.emptyList();
        }
        DBCursor dbCursor = this.fetchListOfValidCommits();
        return this.convertToCommits(dbCursor);
    }

    private DBCursor fetchListOfValidCommits() {
        DBCollection commitCollection = this.nodeStore.getCommitCollection();
        QueryBuilder queryBuilder = QueryBuilder.start((String)"failed").notEquals((Object)Boolean.TRUE);
        if (this.fromRevisionId > -1L) {
            queryBuilder = queryBuilder.and("revId").greaterThanEquals((Object)this.fromRevisionId);
        }
        if (this.toRevisionId > -1L) {
            queryBuilder = queryBuilder.and("revId").lessThanEquals((Object)this.toRevisionId);
        }
        if (!this.includeBranchCommits) {
            queryBuilder = queryBuilder.and(new DBObject[]{new BasicDBObject("branchId", (Object)new BasicDBObject("$exists", (Object)false))});
        }
        DBObject query = queryBuilder.get();
        BasicDBObject orderBy = new BasicDBObject("revId", (Object)-1);
        LOG.debug("Executing query: {}", (Object)query);
        return this.maxEntries > 0 ? commitCollection.find(query).limit(this.maxEntries).sort((DBObject)orderBy) : commitCollection.find(query).sort((DBObject)orderBy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<MongoCommit> convertToCommits(DBCursor dbCursor) {
        try {
            ArrayList<MongoCommit> commits = new ArrayList<MongoCommit>();
            while (dbCursor.hasNext()) {
                commits.add((MongoCommit)dbCursor.next());
            }
            LOG.debug("Found list of valid revisions for max revision {}: {}", (Object)this.toRevisionId, commits);
            ArrayList<MongoCommit> arrayList = commits;
            return arrayList;
        }
        finally {
            dbCursor.close();
        }
    }
}

