/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.mongomk.impl.action;

import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.QueryBuilder;
import org.apache.jackrabbit.mongomk.impl.MongoNodeStore;
import org.apache.jackrabbit.mongomk.impl.action.BaseAction;
import org.apache.jackrabbit.mongomk.impl.model.MongoCommit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FetchCommitAction
extends BaseAction<MongoCommit> {
    private static final Logger LOG = LoggerFactory.getLogger(FetchCommitAction.class);
    private final long revisionId;

    public FetchCommitAction(MongoNodeStore nodeStore, long revisionId) {
        super(nodeStore);
        this.revisionId = revisionId;
    }

    @Override
    public MongoCommit execute() throws Exception {
        MongoCommit commit = this.nodeStore.getFromCache(this.revisionId);
        if (commit != null) {
            return commit;
        }
        DBCollection commitCollection = this.nodeStore.getCommitCollection();
        DBObject query = QueryBuilder.start((String)"failed").notEquals((Object)Boolean.TRUE).and("revId").is((Object)this.revisionId).get();
        LOG.debug("Executing query: {}", (Object)query);
        DBObject dbObject = commitCollection.findOne(query);
        if (dbObject == null) {
            throw new Exception(String.format("Commit with revision %d could not be found", this.revisionId));
        }
        commit = (MongoCommit)dbObject;
        this.nodeStore.cache(commit);
        return commit;
    }
}

