/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.mk.core;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.mk.api.MicroKernel;
import org.apache.jackrabbit.mk.api.MicroKernelException;
import org.apache.jackrabbit.mk.core.Repository;
import org.apache.jackrabbit.mk.model.ChildNodeEntry;
import org.apache.jackrabbit.mk.model.CommitBuilder;
import org.apache.jackrabbit.mk.model.DiffBuilder;
import org.apache.jackrabbit.mk.model.Id;
import org.apache.jackrabbit.mk.model.StoredCommit;
import org.apache.jackrabbit.mk.model.StoredNode;
import org.apache.jackrabbit.mk.store.NotFoundException;
import org.apache.jackrabbit.mk.store.RevisionStore;
import org.apache.jackrabbit.mk.util.CommitGate;
import org.apache.jackrabbit.mk.util.NameFilter;
import org.apache.jackrabbit.mk.util.NodeFilter;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.commons.json.JsonObject;
import org.apache.jackrabbit.oak.commons.json.JsopBuilder;
import org.apache.jackrabbit.oak.commons.json.JsopTokenizer;

public class MicroKernelImpl
implements MicroKernel {
    protected Repository rep;
    private final CommitGate gate = new CommitGate();

    public MicroKernelImpl(String homeDir) throws MicroKernelException {
        this.init(homeDir);
    }

    public MicroKernelImpl() {
        this(new Repository());
    }

    public MicroKernelImpl(Repository rep) {
        this.rep = rep;
        try {
            this.gate.commit(rep.getHeadRevision().toString());
        }
        catch (Exception e) {
            throw new MicroKernelException((Throwable)e);
        }
    }

    protected void init(String homeDir) throws MicroKernelException {
        try {
            this.rep = new Repository(homeDir);
            this.rep.init();
            this.gate.commit(this.rep.getHeadRevision().toString());
        }
        catch (Exception e) {
            throw new MicroKernelException((Throwable)e);
        }
    }

    public void dispose() {
        this.gate.commit("end");
        if (this.rep != null) {
            try {
                this.rep.shutDown();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.rep = null;
        }
    }

    public String getHeadRevision() throws MicroKernelException {
        if (this.rep == null) {
            throw new IllegalStateException("this instance has already been disposed");
        }
        return this.getHeadRevisionId().toString();
    }

    public String checkpoint(long lifetime) throws MicroKernelException {
        return this.getHeadRevision();
    }

    private Id getHeadRevisionId() throws MicroKernelException {
        try {
            return this.rep.getHeadRevision();
        }
        catch (Exception e) {
            throw new MicroKernelException((Throwable)e);
        }
    }

    private Id getBaseRevisionId(Id branchId) throws MicroKernelException {
        try {
            return this.rep.getBaseRevision(branchId);
        }
        catch (Exception e) {
            throw new MicroKernelException((Throwable)e);
        }
    }

    /*
     * Unable to fully structure code
     */
    public String getRevisionHistory(long since, int maxEntries, String path) throws MicroKernelException {
        if (this.rep == null) {
            throw new IllegalStateException("this instance has already been disposed");
        }
        path = path == null || "".equals(path) != false ? "/" : path;
        filtered = "/".equals(path) == false;
        maxEntries = maxEntries < 0 ? 0x7FFFFFFF : maxEntries;
        history = new ArrayList<StoredCommit>();
        try {
            commit = this.rep.getHeadCommit();
            while (commit != null && history.size() < maxEntries && commit.getCommitTS() >= since) {
                if (filtered) {
                    try {
                        rs = this.rep.getRevisionStore();
                        diff = new DiffBuilder(rs.getRootNode(commit.getParentId()), rs.getNode(commit.getRootNodeId()), "/", -1, this.rep.getRevisionStore(), path).build();
                        if (diff.isEmpty()) ** GOTO lbl22
                        history.add(commit);
                    }
                    catch (Exception e) {
                        throw new MicroKernelException((Throwable)e);
                    }
                } else {
                    history.add(commit);
                }
lbl22:
                // 3 sources

                commitId = commit.getParentId();
                if (commitId != null) {
                    commit = this.rep.getCommit(commitId);
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            throw new MicroKernelException((Throwable)e);
        }
        buff = new JsopBuilder().array();
        for (i = history.size() - 1; i >= 0; --i) {
            commit = (StoredCommit)history.get(i);
            buff.object().key("id").value(commit.getId().toString()).key("ts").value(commit.getCommitTS()).key("msg").value(commit.getMsg()).endObject();
        }
        return buff.endArray().toString();
    }

    public String waitForCommit(String oldHeadRevisionId, long maxWaitMillis) throws MicroKernelException, InterruptedException {
        return this.gate.waitForCommit(oldHeadRevisionId, maxWaitMillis);
    }

    public String getJournal(String fromRevision, String toRevision, String path) throws MicroKernelException {
        StoredCommit commit;
        if (this.rep == null) {
            throw new IllegalStateException("this instance has already been disposed");
        }
        path = path == null || "".equals(path) ? "/" : path;
        boolean filtered = !"/".equals(path);
        Id fromRevisionId = Id.fromString(fromRevision);
        Id toRevisionId = toRevision == null ? this.getHeadRevisionId() : Id.fromString(toRevision);
        ArrayList<StoredCommit> commits = new ArrayList<StoredCommit>();
        try {
            StoredCommit toCommit = this.rep.getCommit(toRevisionId);
            StoredCommit fromCommit = toRevisionId.equals(fromRevisionId) ? toCommit : this.rep.getCommit(fromRevisionId);
            if (fromCommit.getBranchRootId() != null && !fromCommit.getBranchRootId().equals(toCommit.getBranchRootId())) {
                throw new MicroKernelException("inconsistent range specified: fromRevision denotes a private branch while toRevision denotes a head or another private branch");
            }
            if (fromCommit.getCommitTS() > toCommit.getCommitTS()) {
                return "[]";
            }
            commit = toCommit;
            while (commit != null) {
                Id commitId;
                commits.add(commit);
                if (!commit.getId().equals(fromRevisionId) && (commitId = commit.getParentId()) != null && (commit = this.rep.getCommit(commitId)).getCommitTS() >= fromCommit.getCommitTS()) continue;
                break;
            }
        }
        catch (MicroKernelException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MicroKernelException((Throwable)e);
        }
        JsopBuilder commitBuff = new JsopBuilder().array();
        for (int i = commits.size() - 1; i >= 0; --i) {
            commit = (StoredCommit)commits.get(i);
            if (commit.getParentId() == null) continue;
            String diff = commit.getChanges();
            if (filtered) {
                try {
                    RevisionStore rs = this.rep.getRevisionStore();
                    diff = new DiffBuilder(rs.getRootNode(commit.getParentId()), rs.getNode(commit.getRootNodeId()), "/", -1, this.rep.getRevisionStore(), path).build();
                    if (diff.isEmpty()) {
                        continue;
                    }
                }
                catch (Exception e) {
                    throw new MicroKernelException((Throwable)e);
                }
            }
            commitBuff.object().key("id").value(commit.getId().toString()).key("ts").value(commit.getCommitTS()).key("msg").value(commit.getMsg());
            if (commit.getBranchRootId() != null) {
                commitBuff.key("branchRootId").value(commit.getBranchRootId().toString());
            }
            commitBuff.key("changes").value(diff).endObject();
        }
        return commitBuff.endArray().toString();
    }

    public String diff(String fromRevision, String toRevision, String path, int depth) throws MicroKernelException {
        Id toRevisionId;
        Id fromRevisionId;
        String string = path = path == null || "".equals(path) ? "/" : path;
        if (depth < -1) {
            throw new IllegalArgumentException("depth");
        }
        if (fromRevision == null || toRevision == null) {
            Id head = this.getHeadRevisionId();
            fromRevisionId = fromRevision == null ? head : Id.fromString(fromRevision);
            toRevisionId = toRevision == null ? head : Id.fromString(toRevision);
        } else {
            fromRevisionId = Id.fromString(fromRevision);
            toRevisionId = Id.fromString(toRevision);
        }
        if (fromRevisionId.equals(toRevisionId)) {
            return "";
        }
        try {
            StoredCommit toCommit;
            if ("/".equals(path) && (toCommit = this.rep.getCommit(toRevisionId)).getParentId().equals(fromRevisionId) && depth == -1) {
                return toCommit.getChanges();
            }
            StoredNode from = null;
            StoredNode to = null;
            try {
                from = this.rep.getNode(fromRevisionId, path);
            }
            catch (NotFoundException ignore) {
                // empty catch block
            }
            try {
                to = this.rep.getNode(toRevisionId, path);
            }
            catch (NotFoundException ignore) {
                // empty catch block
            }
            return new DiffBuilder(from, to, path, depth, this.rep.getRevisionStore(), path).build();
        }
        catch (Exception e) {
            throw new MicroKernelException((Throwable)e);
        }
    }

    public boolean nodeExists(String path, String revisionId) throws MicroKernelException {
        if (this.rep == null) {
            throw new IllegalStateException("this instance has already been disposed");
        }
        Id revId = revisionId == null ? this.getHeadRevisionId() : Id.fromString(revisionId);
        try {
            return this.rep.nodeExists(revId, path);
        }
        catch (Exception e) {
            throw new MicroKernelException((Throwable)e);
        }
    }

    public long getChildNodeCount(String path, String revisionId) throws MicroKernelException {
        if (this.rep == null) {
            throw new IllegalStateException("this instance has already been disposed");
        }
        Id revId = revisionId == null ? this.getHeadRevisionId() : Id.fromString(revisionId);
        try {
            return this.rep.getNode(revId, path).getChildNodeCount();
        }
        catch (NotFoundException e) {
            throw new MicroKernelException("Path " + path + " not found in revision " + revisionId);
        }
        catch (Exception e) {
            throw new MicroKernelException((Throwable)e);
        }
    }

    public String getNodes(String path, String revisionId, int depth, long offset, int maxChildNodes, String filter) throws MicroKernelException {
        NodeFilter nodeFilter;
        if (this.rep == null) {
            throw new IllegalStateException("this instance has already been disposed");
        }
        Id id = null;
        if (!path.startsWith("/")) {
            id = Id.fromString(path);
        }
        Id revId = revisionId == null ? this.getHeadRevisionId() : Id.fromString(revisionId);
        NodeFilter nodeFilter2 = nodeFilter = filter == null || filter.isEmpty() ? null : NodeFilter.parse(filter);
        if (offset > 0L && nodeFilter != null && nodeFilter.getChildNodeFilter() != null) {
            throw new IllegalArgumentException("offset > 0 with child node filter");
        }
        try {
            StoredNode node;
            try {
                node = id != null ? this.rep.getRevisionStore().getNode(id) : this.rep.getNode(revId, path);
            }
            catch (NotFoundException e) {
                return null;
            }
            JsopBuilder buf = new JsopBuilder().object();
            this.toJson(buf, node, depth, (int)offset, maxChildNodes, true, nodeFilter);
            return buf.endObject().toString();
        }
        catch (Exception e) {
            throw new MicroKernelException((Throwable)e);
        }
    }

    public String commit(String path, String jsonDiff, String revisionId, String message) throws MicroKernelException {
        if (this.rep == null) {
            throw new IllegalStateException("this instance has already been disposed");
        }
        if (path.length() > 0 && !PathUtils.isAbsolute((String)path)) {
            throw new IllegalArgumentException("absolute path expected: " + path);
        }
        if (jsonDiff == null || jsonDiff.length() == 0) {
            return revisionId != null ? revisionId : this.getHeadRevision();
        }
        Id revId = revisionId == null ? this.getHeadRevisionId() : Id.fromString(revisionId);
        try {
            int r;
            JsopTokenizer t = new JsopTokenizer(jsonDiff);
            CommitBuilder cb = this.rep.getCommitBuilder(revId, message);
            block9: while ((r = t.read()) != 0) {
                switch (r) {
                    case 43: {
                        int pos = t.getLastPos();
                        String subPath = t.readString();
                        t.read(58);
                        t.read(123);
                        String nodePath = PathUtils.concat((String)path, (String)subPath);
                        if (!PathUtils.isAbsolute((String)nodePath)) {
                            throw new Exception("absolute path expected: " + nodePath + ", pos: " + pos);
                        }
                        String parentPath = PathUtils.getParentPath((String)nodePath);
                        String nodeName = PathUtils.getName((String)nodePath);
                        cb.addNode(parentPath, nodeName, JsonObject.create((JsopTokenizer)t));
                        continue block9;
                    }
                    case 45: {
                        int pos = t.getLastPos();
                        String subPath = t.readString();
                        String targetPath = PathUtils.concat((String)path, (String)subPath);
                        if (!PathUtils.isAbsolute((String)targetPath)) {
                            throw new Exception("absolute path expected: " + targetPath + ", pos: " + pos);
                        }
                        cb.removeNode(targetPath);
                        continue block9;
                    }
                    case 94: {
                        int pos = t.getLastPos();
                        String subPath = t.readString();
                        t.read(58);
                        String value = t.matches(5) ? null : t.readRawValue().trim();
                        String targetPath = PathUtils.concat((String)path, (String)subPath);
                        if (!PathUtils.isAbsolute((String)targetPath)) {
                            throw new Exception("absolute path expected: " + targetPath + ", pos: " + pos);
                        }
                        String parentPath = PathUtils.getParentPath((String)targetPath);
                        String propName = PathUtils.getName((String)targetPath);
                        cb.setProperty(parentPath, propName, value);
                        continue block9;
                    }
                    case 62: {
                        int pos = t.getLastPos();
                        String subPath = t.readString();
                        String srcPath = PathUtils.concat((String)path, (String)subPath);
                        if (!PathUtils.isAbsolute((String)srcPath)) {
                            throw new Exception("absolute path expected: " + srcPath + ", pos: " + pos);
                        }
                        t.read(58);
                        pos = t.getLastPos();
                        String targetPath = t.readString();
                        if (!PathUtils.isAbsolute((String)targetPath) && !PathUtils.isAbsolute((String)(targetPath = PathUtils.concat((String)path, (String)targetPath)))) {
                            throw new Exception("absolute path expected: " + targetPath + ", pos: " + pos);
                        }
                        cb.moveNode(srcPath, targetPath);
                        continue block9;
                    }
                    case 42: {
                        int pos = t.getLastPos();
                        String subPath = t.readString();
                        String srcPath = PathUtils.concat((String)path, (String)subPath);
                        if (!PathUtils.isAbsolute((String)srcPath)) {
                            throw new Exception("absolute path expected: " + srcPath + ", pos: " + pos);
                        }
                        t.read(58);
                        pos = t.getLastPos();
                        String targetPath = t.readString();
                        if (!PathUtils.isAbsolute((String)targetPath) && !PathUtils.isAbsolute((String)(targetPath = PathUtils.concat((String)path, (String)targetPath)))) {
                            throw new Exception("absolute path expected: " + targetPath + ", pos: " + pos);
                        }
                        cb.copyNode(srcPath, targetPath);
                        continue block9;
                    }
                }
                throw new IllegalArgumentException("jsonDiff: illegal token '" + t.getToken() + "' at pos: " + t.getLastPos());
            }
            Id newHead = cb.doCommit();
            if (!newHead.equals(revId) && this.rep.getCommit(newHead).getBranchRootId() == null) {
                this.gate.commit(newHead.toString());
            }
            return newHead.toString();
        }
        catch (Exception e) {
            throw new MicroKernelException((Throwable)e);
        }
    }

    public String branch(String trunkRevisionId) throws MicroKernelException {
        if (this.rep == null) {
            throw new IllegalStateException("this instance has already been disposed");
        }
        Id revId = trunkRevisionId == null ? this.getHeadRevisionId() : Id.fromString(trunkRevisionId);
        try {
            CommitBuilder cb = this.rep.getCommitBuilder(revId, "");
            return cb.doCommit(true).toString();
        }
        catch (Exception e) {
            throw new MicroKernelException((Throwable)e);
        }
    }

    public String merge(String branchRevisionId, String message) throws MicroKernelException {
        if (this.rep == null) {
            throw new IllegalStateException("this instance has already been disposed");
        }
        Id revId = Id.fromString(branchRevisionId);
        try {
            return this.rep.getCommitBuilder(revId, message).doMerge().toString();
        }
        catch (Exception e) {
            throw new MicroKernelException((Throwable)e);
        }
    }

    public String rebase(String branchRevisionId, String newBaseRevisionId) {
        Id newBaseId;
        Id branchId = Id.fromString(branchRevisionId);
        Id baseId = this.getBaseRevisionId(branchId);
        Id id = newBaseId = newBaseRevisionId == null ? this.getHeadRevisionId() : Id.fromString(newBaseRevisionId);
        if (baseId.equals(newBaseId)) {
            return branchRevisionId;
        }
        Id newBranchId = Id.fromString(this.branch(newBaseRevisionId));
        try {
            CommitBuilder cb = this.rep.getCommitBuilder(newBranchId, "rebasing " + branchRevisionId + " onto " + newBaseRevisionId);
            return cb.rebase(baseId, branchId).toString();
        }
        catch (Exception e) {
            throw new MicroKernelException((Throwable)e);
        }
    }

    @Nonnull
    public String reset(@Nonnull String branchRevisionId, @Nonnull String ancestorRevisionId) throws MicroKernelException {
        StoredCommit commit;
        Id branchId = Id.fromString(branchRevisionId);
        Id ancestorId = Id.fromString(ancestorRevisionId);
        try {
            commit = this.rep.getCommit(branchId);
        }
        catch (Exception e) {
            throw new MicroKernelException((Throwable)e);
        }
        Id baseId = commit.getBranchRootId();
        if (baseId == null) {
            throw new MicroKernelException("Not a private branch: " + branchRevisionId);
        }
        while (!ancestorId.equals(branchId)) {
            try {
                commit = this.rep.getCommit(branchId);
            }
            catch (Exception e) {
                throw new MicroKernelException((Throwable)e);
            }
            if (commit.getBranchRootId() == null) {
                throw new MicroKernelException(ancestorRevisionId + " is not " + "an ancestor revision of " + branchRevisionId);
            }
            branchId = commit.getParentId();
        }
        return ancestorRevisionId;
    }

    public long getLength(String blobId) throws MicroKernelException {
        if (this.rep == null) {
            throw new IllegalStateException("this instance has already been disposed");
        }
        try {
            return this.rep.getBlobStore().getBlobLength(blobId);
        }
        catch (Exception e) {
            throw new MicroKernelException((Throwable)e);
        }
    }

    public int read(String blobId, long pos, byte[] buff, int off, int length) throws MicroKernelException {
        if (this.rep == null) {
            throw new IllegalStateException("this instance has already been disposed");
        }
        try {
            int read = this.rep.getBlobStore().readBlob(blobId, pos, buff, off, length);
            return read < 0 ? 0 : read;
        }
        catch (Exception e) {
            throw new MicroKernelException((Throwable)e);
        }
    }

    public String write(InputStream in) throws MicroKernelException {
        if (this.rep == null) {
            throw new IllegalStateException("this instance has already been disposed");
        }
        try {
            return this.rep.getBlobStore().writeBlob(in);
        }
        catch (Exception e) {
            throw new MicroKernelException((Throwable)e);
        }
    }

    void toJson(JsopBuilder builder, StoredNode node, int depth, int offset, int maxChildNodes, boolean inclVirtualProps, NodeFilter filter) throws Exception {
        for (Map.Entry<String, String> prop : node.getProperties().entrySet()) {
            if (filter != null && !filter.includeProperty(prop.getKey())) continue;
            builder.key(prop.getKey()).encodedValue(prop.getValue());
        }
        long childCount = node.getChildNodeCount();
        if (inclVirtualProps) {
            NameFilter nf;
            if (filter == null || filter.includeProperty(":childNodeCount")) {
                builder.key(":childNodeCount").value(childCount);
            }
            if (filter != null && (nf = filter.getPropertyFilter()) != null) {
                if (nf.getInclusionPatterns().contains(":hash") && !nf.getExclusionPatterns().contains(":hash")) {
                    builder.key(":hash").value(node.getId().toString());
                }
                if (nf.getInclusionPatterns().contains(":id") && !nf.getExclusionPatterns().contains(":id")) {
                    builder.key(":id").value(node.getId().toString());
                }
            }
        }
        if (childCount > 0L && depth >= 0) {
            NameFilter childFilter;
            if (filter != null && (childFilter = filter.getChildNodeFilter()) != null && !childFilter.containsWildcard()) {
                int count = maxChildNodes == -1 ? Integer.MAX_VALUE : maxChildNodes;
                for (String name : childFilter.getInclusionPatterns()) {
                    ChildNodeEntry cne = node.getChildNodeEntry(name);
                    if (cne == null) continue;
                    boolean incl = true;
                    for (String exclName : childFilter.getExclusionPatterns()) {
                        if (!name.equals(exclName)) continue;
                        incl = false;
                        break;
                    }
                    if (!incl) continue;
                    if (count-- <= 0) break;
                    builder.key(name).object();
                    if (depth > 0) {
                        this.toJson(builder, this.rep.getRevisionStore().getNode(cne.getId()), depth - 1, 0, maxChildNodes, inclVirtualProps, filter);
                    }
                    builder.endObject();
                }
                return;
            }
            int count = maxChildNodes;
            if (count != -1 && filter != null && filter.getChildNodeFilter() != null) {
                count = -1;
            }
            int numSiblings = 0;
            Iterator<ChildNodeEntry> it = node.getChildNodeEntries(offset, count);
            while (it.hasNext()) {
                ChildNodeEntry cne = it.next();
                if (filter != null && !filter.includeNode(cne.getName())) continue;
                if (maxChildNodes != -1 && ++numSiblings > maxChildNodes) break;
                builder.key(cne.getName()).object();
                if (depth > 0) {
                    this.toJson(builder, this.rep.getRevisionStore().getNode(cne.getId()), depth - 1, 0, maxChildNodes, inclVirtualProps, filter);
                }
                builder.endObject();
            }
        }
    }
}

