/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.mk.util;

import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class AbstractFilteringIterator<T>
implements Iterator<T> {
    protected final Iterator<T> it;
    protected int count;
    protected T next = null;

    public AbstractFilteringIterator(Iterator<T> it) {
        this.it = it;
    }

    @Override
    public boolean hasNext() {
        while (this.next == null && this.it.hasNext()) {
            T entry = this.it.next();
            if (!this.include(entry)) continue;
            this.next = entry;
        }
        return this.next != null;
    }

    protected abstract boolean include(T var1);

    @Override
    public T next() {
        if (this.hasNext()) {
            T entry = this.next;
            this.next = null;
            return entry;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

