/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.mk.store;

import java.util.Iterator;

public interface Binding {
    public void write(String var1, String var2) throws Exception;

    public void write(String var1, byte[] var2) throws Exception;

    public void write(String var1, long var2) throws Exception;

    public void write(String var1, int var2) throws Exception;

    public void writeMap(String var1, int var2, StringEntryIterator var3) throws Exception;

    public void writeMap(String var1, int var2, BytesEntryIterator var3) throws Exception;

    public String readStringValue(String var1) throws Exception;

    public byte[] readBytesValue(String var1) throws Exception;

    public long readLongValue(String var1) throws Exception;

    public int readIntValue(String var1) throws Exception;

    public StringEntryIterator readStringMap(String var1) throws Exception;

    public BytesEntryIterator readBytesMap(String var1) throws Exception;

    public static interface BytesEntryIterator
    extends Iterator<BytesEntry> {
    }

    public static interface StringEntryIterator
    extends Iterator<StringEntry> {
    }

    public static class BytesEntry
    extends Entry<byte[]> {
        public BytesEntry(String key, byte[] value) {
            super(key, value);
        }

        @Override
        public byte[] getValue() {
            return (byte[])this.value;
        }
    }

    public static class StringEntry
    extends Entry<String> {
        public StringEntry(String key, String value) {
            super(key, value);
        }

        @Override
        public String getValue() {
            return (String)this.value;
        }
    }

    public static abstract class Entry<V> {
        String key;
        V value;

        public Entry(String key, V value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public V getValue() {
            return this.value;
        }
    }
}

