/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.mk.model;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.jackrabbit.mk.model.ChildNodeEntries;
import org.apache.jackrabbit.mk.model.ChildNodeEntry;
import org.apache.jackrabbit.mk.model.Id;
import org.apache.jackrabbit.mk.store.Binding;
import org.apache.jackrabbit.mk.store.CacheObject;
import org.apache.jackrabbit.mk.util.AbstractFilteringIterator;
import org.apache.jackrabbit.mk.util.RangeIterator;

public class ChildNodeEntriesMap
implements ChildNodeEntries,
CacheObject {
    protected static final List<ChildNodeEntry> EMPTY = Collections.emptyList();
    protected HashMap<String, ChildNodeEntry> entries = new HashMap();

    public ChildNodeEntriesMap() {
    }

    public ChildNodeEntriesMap(ChildNodeEntriesMap other) {
        this.entries = (HashMap)other.entries.clone();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ChildNodeEntriesMap) {
            return this.entries.equals(((ChildNodeEntriesMap)obj).entries);
        }
        return false;
    }

    @Override
    public Object clone() {
        ChildNodeEntriesMap clone = null;
        try {
            clone = (ChildNodeEntriesMap)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        clone.entries = (HashMap)this.entries.clone();
        return clone;
    }

    @Override
    public boolean inlined() {
        return true;
    }

    @Override
    public int getCount() {
        return this.entries.size();
    }

    @Override
    public ChildNodeEntry get(String name) {
        return this.entries.get(name);
    }

    @Override
    public Iterator<String> getNames(int offset, int count) {
        if (offset < 0 || count < -1) {
            throw new IllegalArgumentException();
        }
        if (offset == 0 && count == -1) {
            return this.entries.keySet().iterator();
        }
        if (offset >= this.entries.size() || count == 0) {
            List empty = Collections.emptyList();
            return empty.iterator();
        }
        if (count == -1 || offset + count > this.entries.size()) {
            count = this.entries.size() - offset;
        }
        return new RangeIterator<String>(this.entries.keySet().iterator(), offset, count);
    }

    @Override
    public Iterator<ChildNodeEntry> getEntries(int offset, int count) {
        if (offset < 0 || count < -1) {
            throw new IllegalArgumentException();
        }
        if (offset == 0 && count == -1) {
            return this.entries.values().iterator();
        }
        if (offset >= this.entries.size() || count == 0) {
            return EMPTY.iterator();
        }
        if (count == -1 || offset + count > this.entries.size()) {
            count = this.entries.size() - offset;
        }
        return new RangeIterator<ChildNodeEntry>(this.entries.values().iterator(), offset, count);
    }

    @Override
    public ChildNodeEntry add(ChildNodeEntry entry) {
        return this.entries.put(entry.getName(), entry);
    }

    @Override
    public ChildNodeEntry remove(String name) {
        return this.entries.remove(name);
    }

    @Override
    public ChildNodeEntry rename(String oldName, String newName) {
        if (oldName.equals(newName)) {
            return this.entries.get(oldName);
        }
        if (this.entries.get(oldName) == null) {
            return null;
        }
        HashMap clone = (HashMap)this.entries.clone();
        this.entries.clear();
        ChildNodeEntry oldCNE = null;
        for (Map.Entry entry : clone.entrySet()) {
            if (((String)entry.getKey()).equals(oldName)) {
                oldCNE = (ChildNodeEntry)entry.getValue();
                this.entries.put(newName, new ChildNodeEntry(newName, oldCNE.getId()));
                continue;
            }
            this.entries.put((String)entry.getKey(), (ChildNodeEntry)entry.getValue());
        }
        return oldCNE;
    }

    @Override
    public Iterator<ChildNodeEntry> getAdded(ChildNodeEntries other) {
        return new AbstractFilteringIterator<ChildNodeEntry>(other.getEntries(0, -1)){

            @Override
            protected boolean include(ChildNodeEntry entry) {
                return !ChildNodeEntriesMap.this.entries.containsKey(entry.getName());
            }
        };
    }

    @Override
    public Iterator<ChildNodeEntry> getRemoved(final ChildNodeEntries other) {
        return new AbstractFilteringIterator<ChildNodeEntry>(this.entries.values().iterator()){

            @Override
            protected boolean include(ChildNodeEntry entry) {
                return other.get(entry.getName()) == null;
            }
        };
    }

    @Override
    public Iterator<ChildNodeEntry> getModified(final ChildNodeEntries other) {
        return new AbstractFilteringIterator<ChildNodeEntry>(this.getEntries(0, -1)){

            @Override
            protected boolean include(ChildNodeEntry entry) {
                ChildNodeEntry namesake = other.get(entry.getName());
                return namesake != null && !namesake.getId().equals(entry.getId());
            }
        };
    }

    @Override
    public void serialize(Binding binding) throws Exception {
        final Iterator<ChildNodeEntry> iter = this.getEntries(0, -1);
        binding.writeMap(":children", this.getCount(), new Binding.BytesEntryIterator(){

            @Override
            public boolean hasNext() {
                return iter.hasNext();
            }

            @Override
            public Binding.BytesEntry next() {
                ChildNodeEntry cne = (ChildNodeEntry)iter.next();
                return new Binding.BytesEntry(cne.getName(), cne.getId().getBytes());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        });
    }

    public static ChildNodeEntriesMap deserialize(Binding binding) throws Exception {
        ChildNodeEntriesMap newInstance = new ChildNodeEntriesMap();
        Binding.BytesEntryIterator iter = binding.readBytesMap(":children");
        while (iter.hasNext()) {
            Binding.BytesEntry entry = (Binding.BytesEntry)iter.next();
            newInstance.add(new ChildNodeEntry(entry.getKey(), new Id(entry.getValue())));
        }
        return newInstance;
    }

    @Override
    public int getMemory() {
        int memory = 100;
        for (String e : this.entries.keySet()) {
            memory += e.length() * 2 + 100;
        }
        return memory;
    }
}

