/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.mk.model;

import org.apache.jackrabbit.mk.model.AbstractCommit;
import org.apache.jackrabbit.mk.model.Commit;
import org.apache.jackrabbit.mk.model.Id;
import org.apache.jackrabbit.mk.store.Binding;

public class StoredCommit
extends AbstractCommit {
    private final Id id;

    public static StoredCommit deserialize(Id id, Binding binding) throws Exception {
        Id rootNodeId = new Id(binding.readBytesValue("rootNodeId"));
        long commitTS = binding.readLongValue("commitTS");
        String msg = binding.readStringValue("msg");
        String changes = binding.readStringValue("changes");
        String parentId = binding.readStringValue("parentId");
        String branchRootId = binding.readStringValue("branchRootId");
        return new StoredCommit(id, "".equals(parentId) ? null : Id.fromString(parentId), commitTS, rootNodeId, "".equals(msg) ? null : msg, changes, "".equals(branchRootId) ? null : Id.fromString(branchRootId));
    }

    public StoredCommit(Id id, Id parentId, long commitTS, Id rootNodeId, String msg, String changes, Id branchRootId) {
        this.id = id;
        this.parentId = parentId;
        this.commitTS = commitTS;
        this.rootNodeId = rootNodeId;
        this.msg = msg;
        this.changes = changes;
        this.branchRootId = branchRootId;
    }

    public StoredCommit(Id id, Commit commit) {
        super(commit);
        this.id = id;
    }

    public Id getId() {
        return this.id;
    }
}

