/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.mk.model;

import org.apache.jackrabbit.mk.model.Commit;
import org.apache.jackrabbit.mk.model.Id;
import org.apache.jackrabbit.mk.store.Binding;
import org.apache.jackrabbit.mk.store.CacheObject;

public abstract class AbstractCommit
implements Commit,
CacheObject {
    protected Id rootNodeId;
    protected long commitTS;
    protected String msg;
    protected String changes;
    protected Id parentId;
    protected Id branchRootId;

    protected AbstractCommit() {
    }

    protected AbstractCommit(Commit other) {
        this.parentId = other.getParentId();
        this.rootNodeId = other.getRootNodeId();
        this.msg = other.getMsg();
        this.changes = other.getChanges();
        this.commitTS = other.getCommitTS();
        this.branchRootId = other.getBranchRootId();
    }

    @Override
    public Id getParentId() {
        return this.parentId;
    }

    @Override
    public Id getRootNodeId() {
        return this.rootNodeId;
    }

    @Override
    public long getCommitTS() {
        return this.commitTS;
    }

    @Override
    public String getMsg() {
        return this.msg;
    }

    @Override
    public String getChanges() {
        return this.changes;
    }

    @Override
    public Id getBranchRootId() {
        return this.branchRootId;
    }

    @Override
    public void serialize(Binding binding) throws Exception {
        binding.write("rootNodeId", this.rootNodeId.getBytes());
        binding.write("commitTS", this.commitTS);
        binding.write("msg", this.msg == null ? "" : this.msg);
        binding.write("changes", this.changes == null ? "" : this.changes);
        binding.write("parentId", this.parentId == null ? "" : this.parentId.toString());
        binding.write("branchRootId", this.branchRootId == null ? "" : this.branchRootId.toString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("rootNodeId: '").append(this.rootNodeId.toString()).append("', ");
        sb.append("commitTS: ").append(this.commitTS).append(", ");
        sb.append("msg: '").append(this.msg == null ? "" : this.msg).append("', ");
        sb.append("changes: '").append(this.changes == null ? "" : this.changes).append("', ");
        sb.append("parentId: '").append(this.parentId == null ? "" : this.parentId.toString()).append("', ");
        sb.append("branchRootId: '").append(this.branchRootId == null ? "" : this.branchRootId.toString()).append("'");
        return sb.toString();
    }

    @Override
    public int getMemory() {
        int memory = 100;
        if (this.msg != null) {
            memory += 2 * this.msg.length();
        }
        if (this.changes != null) {
            memory += 2 * this.changes.length();
        }
        return memory;
    }
}

