/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.mk.osgi;

import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.mk.api.MicroKernel;
import org.apache.jackrabbit.mk.core.MicroKernelImpl;
import org.osgi.service.component.ComponentContext;

@Component(policy=ConfigurationPolicy.REQUIRE)
@Service(value={MicroKernel.class})
public class MicroKernelService
extends MicroKernelImpl {
    @Property(description="The unique name of this instance")
    public static final String NAME = "name";
    @Property(description="The home directory (in-memory if not set)")
    public static final String HOME_DIR = "repository.home";
    private String name;

    public String toString() {
        return this.name;
    }

    @Activate
    public void activate(ComponentContext context) {
        this.name = "" + context.getProperties().get(NAME);
        String homeDir = MicroKernelService.readDirectory(context);
        if (homeDir != null) {
            this.init(homeDir);
        }
    }

    private static String readDirectory(ComponentContext context) {
        if (context.getProperties().get(HOME_DIR) != null) {
            return context.getProperties().get(HOME_DIR).toString();
        }
        if (context.getBundleContext().getProperty(HOME_DIR) != null) {
            return context.getBundleContext().getProperty(HOME_DIR).toString();
        }
        return null;
    }

    @Deactivate
    public void deactivate() {
        this.dispose();
    }
}

