/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.mk.model.tree;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.jackrabbit.mk.model.Id;
import org.apache.jackrabbit.mk.model.tree.NodeState;
import org.apache.jackrabbit.mk.model.tree.NodeStateDiff;
import org.apache.jackrabbit.mk.model.tree.PropertyState;
import org.apache.jackrabbit.mk.store.RevisionProvider;

public class NodeDelta {
    private final RevisionProvider provider;
    private final NodeState node1;
    Map<String, String> addedProperties = new HashMap<String, String>();
    Map<String, String> removedProperties = new HashMap<String, String>();
    Map<String, String> changedProperties = new HashMap<String, String>();
    Map<String, Id> addedChildNodes = new HashMap<String, Id>();
    Map<String, Id> removedChildNodes = new HashMap<String, Id>();
    Map<String, Id> changedChildNodes = new HashMap<String, Id>();

    public NodeDelta(RevisionProvider provider, NodeState node1, NodeState node2) {
        this.provider = provider;
        this.node1 = node1;
        provider.compare(node1, node2, new DiffHandler());
    }

    public Map<String, String> getAddedProperties() {
        return this.addedProperties;
    }

    public Map<String, String> getRemovedProperties() {
        return this.removedProperties;
    }

    public Map<String, String> getChangedProperties() {
        return this.changedProperties;
    }

    public Map<String, Id> getAddedChildNodes() {
        return this.addedChildNodes;
    }

    public Map<String, Id> getRemovedChildNodes() {
        return this.removedChildNodes;
    }

    public Map<String, Id> getChangedChildNodes() {
        return this.changedChildNodes;
    }

    public boolean conflictsWith(NodeDelta other) {
        return !this.listConflicts(other).isEmpty();
    }

    public List<Conflict> listConflicts(NodeDelta other) {
        if (!this.node1.equals(other.node1)) {
            throw new IllegalArgumentException("other and this NodeDelta object are expected to share common node1 instance");
        }
        ArrayList<Conflict> conflicts = new ArrayList<Conflict>();
        Map<String, String> otherAddedProps = other.getAddedProperties();
        for (Map.Entry<String, String> added : this.addedProperties.entrySet()) {
            String otherValue = otherAddedProps.get(added.getKey());
            if (otherValue == null || added.getValue().equals(otherValue)) continue;
            conflicts.add(new Conflict(ConflictType.PROPERTY_VALUE_CONFLICT, added.getKey()));
        }
        Map<String, String> otherChangedProps = other.getChangedProperties();
        Map<String, String> otherRemovedProps = other.getRemovedProperties();
        for (Map.Entry<String, String> changed : this.changedProperties.entrySet()) {
            String otherValue = otherChangedProps.get(changed.getKey());
            if (otherValue != null && !changed.getValue().equals(otherValue)) {
                conflicts.add(new Conflict(ConflictType.PROPERTY_VALUE_CONFLICT, changed.getKey()));
            }
            if (!otherRemovedProps.containsKey(changed.getKey())) continue;
            conflicts.add(new Conflict(ConflictType.REMOVED_DIRTY_PROPERTY_CONFLICT, changed.getKey()));
        }
        for (Map.Entry<String, String> removed : this.removedProperties.entrySet()) {
            if (!otherChangedProps.containsKey(removed.getKey())) continue;
            conflicts.add(new Conflict(ConflictType.REMOVED_DIRTY_PROPERTY_CONFLICT, removed.getKey()));
        }
        Map<String, Id> otherAddedChildNodes = other.getAddedChildNodes();
        for (Map.Entry<String, Id> added : this.addedChildNodes.entrySet()) {
            Id otherValue = otherAddedChildNodes.get(added.getKey());
            if (otherValue == null || added.getValue().equals(otherValue)) continue;
            conflicts.add(new Conflict(ConflictType.NODE_CONTENT_CONFLICT, added.getKey()));
        }
        Map<String, Id> otherChangedChildNodes = other.getChangedChildNodes();
        Map<String, Id> otherRemovedChildNodes = other.getRemovedChildNodes();
        for (Map.Entry<String, Id> changed : this.changedChildNodes.entrySet()) {
            Id otherValue = otherChangedChildNodes.get(changed.getKey());
            if (otherValue != null && !changed.getValue().equals(otherValue)) {
                conflicts.add(new Conflict(ConflictType.NODE_CONTENT_CONFLICT, changed.getKey()));
            }
            if (!otherRemovedChildNodes.containsKey(changed.getKey())) continue;
            conflicts.add(new Conflict(ConflictType.REMOVED_DIRTY_NODE_CONFLICT, changed.getKey()));
        }
        for (Map.Entry<String, Id> removed : this.removedChildNodes.entrySet()) {
            if (!otherChangedChildNodes.containsKey(removed.getKey())) continue;
            conflicts.add(new Conflict(ConflictType.REMOVED_DIRTY_NODE_CONFLICT, removed.getKey()));
        }
        return conflicts;
    }

    public static class Conflict {
        final ConflictType type;
        final String name;

        Conflict(ConflictType type, String name) {
            this.type = type;
            this.name = name;
        }

        public ConflictType getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }
    }

    private class DiffHandler
    implements NodeStateDiff {
        private DiffHandler() {
        }

        @Override
        public void propertyAdded(PropertyState after) {
            NodeDelta.this.addedProperties.put(after.getName(), after.getEncodedValue());
        }

        @Override
        public void propertyChanged(PropertyState before, PropertyState after) {
            NodeDelta.this.changedProperties.put(after.getName(), after.getEncodedValue());
        }

        @Override
        public void propertyDeleted(PropertyState before) {
            NodeDelta.this.removedProperties.put(before.getName(), before.getEncodedValue());
        }

        @Override
        public void childNodeAdded(String name, NodeState after) {
            NodeDelta.this.addedChildNodes.put(name, NodeDelta.this.provider.getId(after));
        }

        @Override
        public void childNodeChanged(String name, NodeState before, NodeState after) {
            NodeDelta.this.changedChildNodes.put(name, NodeDelta.this.provider.getId(after));
        }

        @Override
        public void childNodeDeleted(String name, NodeState before) {
            NodeDelta.this.removedChildNodes.put(name, NodeDelta.this.provider.getId(before));
        }
    }

    public static enum ConflictType {
        PROPERTY_VALUE_CONFLICT,
        NODE_CONTENT_CONFLICT,
        REMOVED_DIRTY_PROPERTY_CONFLICT,
        REMOVED_DIRTY_NODE_CONFLICT;

    }
}

