/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.mk.model.tree;

import java.util.HashMap;
import java.util.Map;
import org.apache.jackrabbit.mk.json.JsopBuilder;
import org.apache.jackrabbit.mk.model.tree.ChildNode;
import org.apache.jackrabbit.mk.model.tree.NodeState;
import org.apache.jackrabbit.mk.model.tree.NodeStore;
import org.apache.jackrabbit.mk.model.tree.PropertyState;
import org.apache.jackrabbit.mk.model.tree.TraversingNodeDiffHandler;
import org.apache.jackrabbit.oak.commons.PathUtils;

public class DiffBuilder {
    private final NodeState before;
    private final NodeState after;
    private final String path;
    private final int depth;
    private final String pathFilter;
    private final NodeStore store;

    public DiffBuilder(NodeState before, NodeState after, String path, int depth, NodeStore store, String pathFilter) {
        this.before = before;
        this.after = after;
        this.path = path;
        this.depth = depth;
        this.store = store;
        this.pathFilter = pathFilter == null || "".equals(pathFilter) ? "/" : pathFilter;
    }

    public String build() throws Exception {
        final JsopBuilder buff = new JsopBuilder();
        final HashMap addedNodes = new HashMap();
        final HashMap removedNodes = new HashMap();
        if (!PathUtils.isAncestor((String)this.path, (String)this.pathFilter) && !this.path.startsWith(this.pathFilter)) {
            return "";
        }
        if (this.before == null) {
            if (this.after != null) {
                buff.tag('+').key(this.path).object();
                this.toJson(buff, this.after, this.depth);
                return buff.endObject().newline().toString();
            }
            return "";
        }
        if (this.after == null) {
            buff.tag('-');
            buff.value(this.path);
            return buff.newline().toString();
        }
        TraversingNodeDiffHandler diffHandler = new TraversingNodeDiffHandler(this.store){
            int levels;
            {
                super(x0);
                this.levels = DiffBuilder.this.depth < 0 ? Integer.MAX_VALUE : DiffBuilder.this.depth;
            }

            @Override
            public void propertyAdded(PropertyState after) {
                String p = PathUtils.concat((String)this.getCurrentPath(), (String)after.getName());
                if (p.startsWith(DiffBuilder.this.pathFilter)) {
                    buff.tag('^').key(p).encodedValue(after.getEncodedValue()).newline();
                }
            }

            @Override
            public void propertyChanged(PropertyState before, PropertyState after) {
                String p = PathUtils.concat((String)this.getCurrentPath(), (String)after.getName());
                if (p.startsWith(DiffBuilder.this.pathFilter)) {
                    buff.tag('^').key(p).encodedValue(after.getEncodedValue()).newline();
                }
            }

            @Override
            public void propertyDeleted(PropertyState before) {
                String p = PathUtils.concat((String)this.getCurrentPath(), (String)before.getName());
                if (p.startsWith(DiffBuilder.this.pathFilter)) {
                    buff.tag('^').key(p).value(null).newline();
                }
            }

            @Override
            public void childNodeAdded(String name, NodeState after) {
                String p = PathUtils.concat((String)this.getCurrentPath(), (String)name);
                if (p.startsWith(DiffBuilder.this.pathFilter)) {
                    addedNodes.put(after, p);
                    buff.tag('+').key(p).object();
                    DiffBuilder.this.toJson(buff, after, DiffBuilder.this.depth);
                    buff.endObject().newline();
                }
            }

            @Override
            public void childNodeDeleted(String name, NodeState before) {
                String p = PathUtils.concat((String)this.getCurrentPath(), (String)name);
                if (p.startsWith(DiffBuilder.this.pathFilter)) {
                    removedNodes.put(before, p);
                    buff.tag('-');
                    buff.value(p);
                    buff.newline();
                }
            }

            @Override
            public void childNodeChanged(String name, NodeState before, NodeState after) {
                String p = PathUtils.concat((String)this.getCurrentPath(), (String)name);
                if (PathUtils.isAncestor((String)p, (String)DiffBuilder.this.pathFilter) || p.startsWith(DiffBuilder.this.pathFilter)) {
                    --this.levels;
                    if (this.levels >= 0) {
                        super.childNodeChanged(name, before, after);
                    } else {
                        buff.tag('^');
                        buff.key(p);
                        buff.object().endObject();
                        buff.newline();
                    }
                    ++this.levels;
                }
            }
        };
        diffHandler.start(this.before, this.after, this.path);
        addedNodes.keySet().retainAll(removedNodes.keySet());
        if (!addedNodes.isEmpty()) {
            removedNodes.keySet().retainAll(addedNodes.keySet());
            buff.resetWriter();
            diffHandler = new TraversingNodeDiffHandler(this.store){
                int levels;
                {
                    super(x0);
                    this.levels = DiffBuilder.this.depth < 0 ? Integer.MAX_VALUE : DiffBuilder.this.depth;
                }

                @Override
                public void propertyAdded(PropertyState after) {
                    String p = PathUtils.concat((String)this.getCurrentPath(), (String)after.getName());
                    if (p.startsWith(DiffBuilder.this.pathFilter)) {
                        buff.tag('^').key(p).encodedValue(after.getEncodedValue()).newline();
                    }
                }

                @Override
                public void propertyChanged(PropertyState before, PropertyState after) {
                    String p = PathUtils.concat((String)this.getCurrentPath(), (String)after.getName());
                    if (p.startsWith(DiffBuilder.this.pathFilter)) {
                        buff.tag('^').key(p).encodedValue(after.getEncodedValue()).newline();
                    }
                }

                @Override
                public void propertyDeleted(PropertyState before) {
                    String p = PathUtils.concat((String)this.getCurrentPath(), (String)before.getName());
                    if (p.startsWith(DiffBuilder.this.pathFilter)) {
                        buff.tag('^').key(p).value(null).newline();
                    }
                }

                @Override
                public void childNodeAdded(String name, NodeState after) {
                    if (addedNodes.containsKey(after)) {
                        return;
                    }
                    String p = PathUtils.concat((String)this.getCurrentPath(), (String)name);
                    if (p.startsWith(DiffBuilder.this.pathFilter)) {
                        buff.tag('+').key(p).object();
                        DiffBuilder.this.toJson(buff, after, DiffBuilder.this.depth);
                        buff.endObject().newline();
                    }
                }

                @Override
                public void childNodeDeleted(String name, NodeState before) {
                    if (addedNodes.containsKey(before)) {
                        return;
                    }
                    String p = PathUtils.concat((String)this.getCurrentPath(), (String)name);
                    if (p.startsWith(DiffBuilder.this.pathFilter)) {
                        buff.tag('-');
                        buff.value(p);
                        buff.newline();
                    }
                }

                @Override
                public void childNodeChanged(String name, NodeState before, NodeState after) {
                    String p = PathUtils.concat((String)this.getCurrentPath(), (String)name);
                    if (PathUtils.isAncestor((String)p, (String)DiffBuilder.this.pathFilter) || p.startsWith(DiffBuilder.this.pathFilter)) {
                        --this.levels;
                        if (this.levels >= 0) {
                            super.childNodeChanged(name, before, after);
                        } else {
                            buff.tag('^');
                            buff.value(p);
                            buff.newline();
                        }
                        ++this.levels;
                    }
                }
            };
            diffHandler.start(this.before, this.after, this.path);
            for (Map.Entry entry : addedNodes.entrySet()) {
                buff.tag('>').key((String)removedNodes.get(entry.getKey())).value((String)entry.getValue()).newline();
            }
        }
        return buff.toString();
    }

    private void toJson(JsopBuilder builder, NodeState node, int depth) {
        for (PropertyState propertyState : node.getProperties()) {
            builder.key(propertyState.getName()).encodedValue(propertyState.getEncodedValue());
        }
        if (depth != 0) {
            for (ChildNode childNode : node.getChildNodeEntries(0L, -1)) {
                builder.key(childNode.getName()).object();
                this.toJson(builder, childNode.getNode(), depth < 0 ? depth : depth - 1);
                builder.endObject();
            }
        }
    }
}

