/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.mk.persistence;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.jackrabbit.mk.model.ChildNodeEntries;
import org.apache.jackrabbit.mk.model.ChildNodeEntriesMap;
import org.apache.jackrabbit.mk.model.Commit;
import org.apache.jackrabbit.mk.model.Id;
import org.apache.jackrabbit.mk.model.Node;
import org.apache.jackrabbit.mk.model.StoredCommit;
import org.apache.jackrabbit.mk.model.StoredNode;
import org.apache.jackrabbit.mk.persistence.GCPersistence;
import org.apache.jackrabbit.mk.store.BinaryBinding;
import org.apache.jackrabbit.mk.store.IdFactory;
import org.apache.jackrabbit.mk.store.NotFoundException;

public class InMemPersistence
implements GCPersistence {
    private final Map<Id, byte[]> objects = Collections.synchronizedMap(new HashMap());
    private final Map<Id, byte[]> marked = Collections.synchronizedMap(new HashMap());
    private long gcStart;
    private IdFactory idFactory = IdFactory.getDigestFactory();

    @Override
    public void initialize(File homeDir) {
    }

    @Override
    public Id[] readIds() throws Exception {
        return new Id[2];
    }

    @Override
    public void writeHead(Id id) {
    }

    @Override
    public void readNode(StoredNode node) throws NotFoundException, Exception {
        Id id = node.getId();
        byte[] bytes = this.objects.get(id);
        if (bytes != null) {
            node.deserialize(new BinaryBinding(new ByteArrayInputStream(bytes)));
            return;
        }
        throw new NotFoundException(id.toString());
    }

    @Override
    public Id writeNode(Node node) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        node.serialize(new BinaryBinding(out));
        byte[] bytes = out.toByteArray();
        Id id = new Id(this.idFactory.createContentId(bytes));
        if (!this.objects.containsKey(id)) {
            this.objects.put(id, bytes);
        }
        if (this.gcStart != 0L) {
            this.marked.put(id, bytes);
        }
        return id;
    }

    @Override
    public StoredCommit readCommit(Id id) throws NotFoundException, Exception {
        byte[] bytes = this.objects.get(id);
        if (bytes != null) {
            return StoredCommit.deserialize(id, new BinaryBinding(new ByteArrayInputStream(bytes)));
        }
        throw new NotFoundException(id.toString());
    }

    @Override
    public void writeCommit(Id id, Commit commit) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        commit.serialize(new BinaryBinding(out));
        byte[] bytes = out.toByteArray();
        if (!this.objects.containsKey(id)) {
            this.objects.put(id, bytes);
        }
        if (this.gcStart != 0L) {
            this.marked.put(id, bytes);
        }
    }

    @Override
    public ChildNodeEntriesMap readCNEMap(Id id) throws NotFoundException, Exception {
        byte[] bytes = this.objects.get(id);
        if (bytes != null) {
            return ChildNodeEntriesMap.deserialize(new BinaryBinding(new ByteArrayInputStream(bytes)));
        }
        throw new NotFoundException(id.toString());
    }

    @Override
    public Id writeCNEMap(ChildNodeEntries map) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        map.serialize(new BinaryBinding(out));
        byte[] bytes = out.toByteArray();
        Id id = new Id(this.idFactory.createContentId(bytes));
        if (!this.objects.containsKey(id)) {
            this.objects.put(id, bytes);
        }
        if (this.gcStart != 0L) {
            this.marked.put(id, bytes);
        }
        return id;
    }

    @Override
    public void close() {
    }

    @Override
    public void start() {
        this.gcStart = System.currentTimeMillis();
        this.marked.clear();
    }

    @Override
    public boolean markCommit(Id id) throws NotFoundException {
        return this.markObject(id);
    }

    @Override
    public boolean markNode(Id id) throws NotFoundException {
        return this.markObject(id);
    }

    @Override
    public boolean markCNEMap(Id id) throws NotFoundException {
        return this.markObject(id);
    }

    @Override
    public void replaceCommit(Id id, Commit commit) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        commit.serialize(new BinaryBinding(out));
        byte[] bytes = out.toByteArray();
        this.objects.put(id, bytes);
        this.marked.put(id, bytes);
    }

    private boolean markObject(Id id) throws NotFoundException {
        byte[] data = this.objects.get(id);
        if (data != null) {
            return this.marked.put(id, data) == null;
        }
        throw new NotFoundException(id.toString());
    }

    @Override
    public int sweep() {
        int count = this.objects.size();
        this.objects.clear();
        this.objects.putAll(this.marked);
        this.gcStart = 0L;
        return count;
    }
}

