/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.mk.model.tree;

import org.apache.jackrabbit.mk.model.tree.ChildNode;
import org.apache.jackrabbit.mk.model.tree.NodeState;
import org.apache.jackrabbit.mk.model.tree.PropertyState;

public abstract class AbstractNodeState
implements NodeState {
    @Override
    public PropertyState getProperty(String name) {
        for (PropertyState propertyState : this.getProperties()) {
            if (!name.equals(propertyState.getName())) continue;
            return propertyState;
        }
        return null;
    }

    @Override
    public long getPropertyCount() {
        long count = 0L;
        for (PropertyState propertyState : this.getProperties()) {
            ++count;
        }
        return count;
    }

    @Override
    public NodeState getChildNode(String name) {
        for (ChildNode childNode : this.getChildNodeEntries(0L, -1)) {
            if (!name.equals(childNode.getName())) continue;
            return childNode.getNode();
        }
        return null;
    }

    @Override
    public long getChildNodeCount() {
        long count = 0L;
        for (ChildNode childNode : this.getChildNodeEntries(0L, -1)) {
            ++count;
        }
        return count;
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null || !(that instanceof NodeState)) {
            return false;
        }
        NodeState other = (NodeState)that;
        long propertyCount = 0L;
        for (PropertyState propertyState : this.getProperties()) {
            if (!propertyState.equals(other.getProperty(propertyState.getName()))) {
                return false;
            }
            ++propertyCount;
        }
        if (propertyCount != other.getPropertyCount()) {
            return false;
        }
        long childNodeCount = 0L;
        for (ChildNode childNode : this.getChildNodeEntries(0L, -1)) {
            if (!childNode.getNode().equals(other.getChildNode(childNode.getName()))) {
                return false;
            }
            ++childNodeCount;
        }
        return childNodeCount == other.getChildNodeCount();
    }

    public int hashCode() {
        return 0;
    }
}

