/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.mk.store;

import java.io.Closeable;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.WeakHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.jackrabbit.mk.model.ChildNodeEntries;
import org.apache.jackrabbit.mk.model.ChildNodeEntriesMap;
import org.apache.jackrabbit.mk.model.ChildNodeEntry;
import org.apache.jackrabbit.mk.model.Id;
import org.apache.jackrabbit.mk.model.MutableCommit;
import org.apache.jackrabbit.mk.model.MutableNode;
import org.apache.jackrabbit.mk.model.NodeDiffHandler;
import org.apache.jackrabbit.mk.model.StoredCommit;
import org.apache.jackrabbit.mk.model.StoredNode;
import org.apache.jackrabbit.mk.model.tree.NodeState;
import org.apache.jackrabbit.mk.model.tree.NodeStateDiff;
import org.apache.jackrabbit.mk.persistence.GCPersistence;
import org.apache.jackrabbit.mk.persistence.Persistence;
import org.apache.jackrabbit.mk.store.AbstractRevisionStore;
import org.apache.jackrabbit.mk.store.NotFoundException;
import org.apache.jackrabbit.mk.store.PersistHook;
import org.apache.jackrabbit.mk.store.RevisionProvider;
import org.apache.jackrabbit.mk.store.RevisionStore;
import org.apache.jackrabbit.mk.store.StoredNodeAsState;
import org.apache.jackrabbit.mk.util.IOUtils;
import org.apache.jackrabbit.mk.util.SimpleLRUCache;

public class DefaultRevisionStore
extends AbstractRevisionStore
implements Closeable {
    public static final String CACHE_SIZE = "mk.cacheSize";
    public static final int DEFAULT_CACHE_SIZE = 10000;
    private boolean initialized;
    private Id head;
    private final AtomicLong commitCounter = new AtomicLong();
    private final ReentrantReadWriteLock headLock = new ReentrantReadWriteLock();
    private final Persistence pm;
    protected final GCPersistence gcpm;
    int initialCacheSize;
    Map<Id, Object> cache;
    private static final int NOT_ACTIVE = 0;
    private static final int STARTING = 1;
    private static final int MARKING = 2;
    private static final int SWEEPING = 3;
    private final AtomicInteger gcState = new AtomicInteger();
    private ScheduledExecutorService gcExecutor;
    private final Map<PutTokenImpl, Object> putTokens = Collections.synchronizedMap(new WeakHashMap());
    private final ReentrantReadWriteLock tokensLock = new ReentrantReadWriteLock();
    private final TreeMap<Id, Id> branches = new TreeMap();

    public DefaultRevisionStore(Persistence pm) {
        this(pm, pm instanceof GCPersistence ? (GCPersistence)pm : null);
    }

    public DefaultRevisionStore(Persistence pm, GCPersistence gcpm) {
        this.pm = pm;
        this.gcpm = gcpm;
    }

    public void initialize() throws Exception {
        if (this.initialized) {
            throw new IllegalStateException("already initialized");
        }
        this.initialCacheSize = DefaultRevisionStore.determineInitialCacheSize();
        this.cache = Collections.synchronizedMap(SimpleLRUCache.newInstance(this.initialCacheSize));
        this.head = this.pm.readHead();
        if (this.head == null || this.head.getBytes().length == 0) {
            byte[] rawHead = Id.fromLong(this.commitCounter.incrementAndGet()).getBytes();
            this.head = new Id(rawHead);
            Id rootNodeId = this.pm.writeNode(new MutableNode(this));
            MutableCommit initialCommit = new MutableCommit();
            initialCommit.setCommitTS(System.currentTimeMillis());
            initialCommit.setRootNodeId(rootNodeId);
            this.pm.writeCommit(this.head, initialCommit);
            this.pm.writeHead(this.head);
        } else {
            this.commitCounter.set(Long.parseLong(this.head.toString(), 16));
        }
        if (this.gcpm != null) {
            this.gcExecutor = Executors.newScheduledThreadPool(1, new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    return new Thread(r, "RevisionStore-GC");
                }
            });
            this.gcExecutor.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    if (DefaultRevisionStore.this.cache.size() >= DefaultRevisionStore.this.initialCacheSize) {
                        DefaultRevisionStore.this.gc();
                    }
                }
            }, 60L, 1L, TimeUnit.MINUTES);
        }
        this.initialized = true;
    }

    @Override
    public void close() {
        this.verifyInitialized();
        if (this.gcExecutor != null) {
            this.gcExecutor.shutdown();
        }
        this.cache.clear();
        IOUtils.closeQuietly(this.pm);
        this.initialized = false;
    }

    protected void verifyInitialized() {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
    }

    protected static int determineInitialCacheSize() {
        String val = System.getProperty(CACHE_SIZE);
        return val != null ? Integer.parseInt(val) : 10000;
    }

    @Override
    public RevisionStore.PutToken createPutToken() {
        return new PutTokenImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Id putNode(RevisionStore.PutToken token, MutableNode node) throws Exception {
        this.verifyInitialized();
        MutableNode callback = null;
        if (node instanceof PersistHook) {
            callback = node;
            callback.prePersist(this, token);
        }
        this.tokensLock.readLock().lock();
        try {
            Id id = this.pm.writeNode(node);
            if (callback != null) {
                callback.postPersist(this, token);
            }
            StoredNode snode = new StoredNode(id, node, this);
            this.cache.put(id, snode);
            PutTokenImpl pti = (PutTokenImpl)token;
            pti.updateLastModifed(snode);
            this.putTokens.put(pti, null);
            Id id2 = id;
            return id2;
        }
        finally {
            this.tokensLock.readLock().unlock();
        }
    }

    @Override
    public Id putCNEMap(RevisionStore.PutToken token, ChildNodeEntries map) throws Exception {
        this.verifyInitialized();
        PersistHook callback = null;
        if (map instanceof PersistHook) {
            callback = (PersistHook)((Object)map);
            callback.prePersist(this, token);
        }
        Id id = this.pm.writeCNEMap(map);
        if (callback != null) {
            callback.postPersist(this, token);
        }
        this.cache.put(id, map);
        return id;
    }

    @Override
    public void lockHead() {
        this.headLock.writeLock().lock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Id putHeadCommit(RevisionStore.PutToken token, MutableCommit commit, Id branchRootId) throws Exception {
        this.verifyInitialized();
        if (!this.headLock.writeLock().isHeldByCurrentThread()) {
            throw new IllegalStateException("putHeadCommit called without holding write lock.");
        }
        Id id = this.writeCommit(token, commit);
        this.setHeadCommitId(id);
        this.putTokens.remove(token);
        if (branchRootId != null) {
            TreeMap<Id, Id> treeMap = this.branches;
            synchronized (treeMap) {
                this.branches.remove(branchRootId);
            }
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Id putCommit(RevisionStore.PutToken token, MutableCommit commit) throws Exception {
        this.verifyInitialized();
        Id commitId = this.writeCommit(token, commit);
        this.putTokens.remove(token);
        Id branchRootId = commit.getBranchRootId();
        if (branchRootId != null) {
            TreeMap<Id, Id> treeMap = this.branches;
            synchronized (treeMap) {
                this.branches.put(branchRootId, commitId);
            }
        }
        return commitId;
    }

    @Override
    public void unlockHead() {
        this.headLock.writeLock().unlock();
    }

    @Override
    public StoredNode getNode(Id id) throws NotFoundException, Exception {
        this.verifyInitialized();
        StoredNode node = (StoredNode)this.cache.get(id);
        if (node != null) {
            return node;
        }
        node = new StoredNode(id, (RevisionProvider)this);
        this.pm.readNode(node);
        this.cache.put(id, node);
        return node;
    }

    @Override
    public ChildNodeEntriesMap getCNEMap(Id id) throws NotFoundException, Exception {
        this.verifyInitialized();
        ChildNodeEntriesMap map = (ChildNodeEntriesMap)this.cache.get(id);
        if (map != null) {
            return map;
        }
        map = this.pm.readCNEMap(id);
        this.cache.put(id, map);
        return map;
    }

    @Override
    public StoredCommit getCommit(Id id) throws NotFoundException, Exception {
        this.verifyInitialized();
        StoredCommit commit = (StoredCommit)this.cache.get(id);
        if (commit != null) {
            return commit;
        }
        commit = this.pm.readCommit(id);
        this.cache.put(id, commit);
        return commit;
    }

    @Override
    public StoredNode getRootNode(Id commitId) throws NotFoundException, Exception {
        return this.getNode(this.getCommit(commitId).getRootNodeId());
    }

    @Override
    public StoredCommit getHeadCommit() throws Exception {
        return this.getCommit(this.getHeadCommitId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Id getHeadCommitId() throws Exception {
        this.verifyInitialized();
        this.headLock.readLock().lock();
        try {
            Id id = this.head;
            return id;
        }
        finally {
            this.headLock.readLock().unlock();
        }
    }

    private Id writeCommit(RevisionStore.PutToken token, MutableCommit commit) throws Exception {
        Id id;
        PersistHook callback = null;
        if (commit instanceof PersistHook) {
            callback = (PersistHook)((Object)commit);
            callback.prePersist(this, token);
        }
        if ((id = commit.getId()) == null) {
            id = Id.fromLong(this.commitCounter.incrementAndGet());
        }
        this.pm.writeCommit(id, commit);
        if (callback != null) {
            callback.postPersist(this, token);
        }
        this.cache.put(id, new StoredCommit(id, commit));
        return id;
    }

    private void setHeadCommitId(Id id) throws Exception {
        this.pm.writeHead(id);
        this.head = id;
        long counter = Long.parseLong(id.toString(), 16);
        if (counter > this.commitCounter.get()) {
            this.commitCounter.set(counter);
        }
    }

    @Override
    public void compare(final NodeState before, final NodeState after, final NodeStateDiff diff) {
        StoredNode beforeNode = ((StoredNodeAsState)before).unwrap();
        StoredNode afterNode = ((StoredNodeAsState)after).unwrap();
        beforeNode.diff(afterNode, new NodeDiffHandler(){

            @Override
            public void propAdded(String propName, String value) {
                diff.propertyAdded(after.getProperty(propName));
            }

            @Override
            public void propChanged(String propName, String oldValue, String newValue) {
                diff.propertyChanged(before.getProperty(propName), after.getProperty(propName));
            }

            @Override
            public void propDeleted(String propName, String value) {
                diff.propertyDeleted(before.getProperty(propName));
            }

            @Override
            public void childNodeAdded(ChildNodeEntry added) {
                String name = added.getName();
                diff.childNodeAdded(name, after.getChildNode(name));
            }

            @Override
            public void childNodeDeleted(ChildNodeEntry deleted) {
                String name = deleted.getName();
                diff.childNodeDeleted(name, before.getChildNode(name));
            }

            @Override
            public void childNodeChanged(ChildNodeEntry changed, Id newId) {
                String name = changed.getName();
                diff.childNodeChanged(name, before.getChildNode(name), after.getChildNode(name));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void gc() {
        if (this.gcpm == null || !this.gcState.compareAndSet(0, 1)) {
            return;
        }
        try {
            StoredCommit commit;
            this.markUncommittedNodes();
            Id firstBranchRootId = this.markBranches();
            Id firstCommitId = this.markCommits();
            if (firstBranchRootId != null && firstBranchRootId.compareTo(firstCommitId) < 0) {
                firstCommitId = firstBranchRootId;
            }
            if ((commit = this.getCommit(firstCommitId)).getParentId() != null) {
                MutableCommit firstCommit = new MutableCommit(commit);
                firstCommit.setParentId(null);
                this.gcpm.replaceCommit(firstCommit.getId(), firstCommit);
            }
        }
        catch (Exception e) {
            this.gcState.set(0);
            e.printStackTrace();
            return;
        }
        this.gcState.set(3);
        try {
            this.gcpm.sweep();
            this.cache.clear();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.gcState.set(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markUncommittedNodes() throws Exception {
        this.tokensLock.writeLock().lock();
        try {
            PutTokenImpl[] tokens;
            this.gcpm.start();
            this.gcState.set(2);
            for (PutTokenImpl token : tokens = this.putTokens.keySet().toArray(new PutTokenImpl[this.putTokens.size()])) {
                this.markNode(token.getLastModified());
            }
        }
        finally {
            this.tokensLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Id markBranches() throws Exception {
        Map tmpBranches;
        TreeMap<Id, Id> treeMap = this.branches;
        synchronized (treeMap) {
            tmpBranches = (Map)this.branches.clone();
        }
        for (Map.Entry entry : tmpBranches.entrySet()) {
            Id branchRootId = (Id)entry.getKey();
            Id branchHeadId = (Id)entry.getValue();
            while (!branchHeadId.equals(branchRootId)) {
                StoredCommit commit = this.getCommit(branchHeadId);
                this.markCommit(commit);
                branchHeadId = commit.getParentId();
            }
        }
        if (!tmpBranches.isEmpty()) {
            Id firstBranchRootId = (Id)tmpBranches.keySet().iterator().next();
            StoredCommit commit = this.getHeadCommit();
            while (true) {
                this.markCommit(commit);
                if (commit.getId().equals(firstBranchRootId)) break;
                commit = this.getCommit(commit.getParentId());
            }
            return firstBranchRootId;
        }
        return null;
    }

    protected Id markCommits() throws Exception {
        StoredCommit commit = this.getHeadCommit();
        long tsLimit = commit.getCommitTS() - 3600000L;
        while (true) {
            StoredCommit parentCommit;
            this.markCommit(commit);
            Id id = commit.getParentId();
            if (id == null || (parentCommit = this.getCommit(id)).getCommitTS() < tsLimit) break;
            commit = parentCommit;
        }
        return commit.getId();
    }

    protected void markCommit(StoredCommit commit) throws Exception {
        if (!this.gcpm.markCommit(commit.getId())) {
            return;
        }
        this.markNode(this.getNode(commit.getRootNodeId()));
    }

    private void markNode(StoredNode node) throws Exception {
        if (!this.gcpm.markNode(node.getId())) {
            return;
        }
        Iterator<ChildNodeEntry> iter = node.getChildNodeEntries(0, -1);
        while (iter.hasNext()) {
            ChildNodeEntry c = iter.next();
            this.markNode(this.getNode(c.getId()));
        }
    }

    static class PutTokenImpl
    extends RevisionStore.PutToken {
        private static int idCounter;
        private int id = ++idCounter;
        private StoredNode lastModifiedNode;

        public int hashCode() {
            return this.id;
        }

        public boolean equals(Object obj) {
            if (obj instanceof PutTokenImpl) {
                return ((PutTokenImpl)obj).id == this.id;
            }
            return super.equals(obj);
        }

        public void updateLastModifed(StoredNode lastModifiedNode) {
            this.lastModifiedNode = lastModifiedNode;
        }

        public StoredNode getLastModified() {
            return this.lastModifiedNode;
        }
    }
}

