/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.mk.model;

import java.util.ArrayList;
import java.util.List;
import org.apache.jackrabbit.mk.json.JsonObject;
import org.apache.jackrabbit.mk.json.JsopBuilder;
import org.apache.jackrabbit.mk.model.Id;
import org.apache.jackrabbit.mk.model.MutableCommit;
import org.apache.jackrabbit.mk.model.StagedNodeTree;
import org.apache.jackrabbit.mk.model.StoredCommit;
import org.apache.jackrabbit.mk.model.StoredNode;
import org.apache.jackrabbit.mk.model.tree.DiffBuilder;
import org.apache.jackrabbit.mk.store.NotFoundException;
import org.apache.jackrabbit.mk.store.RevisionStore;
import org.apache.jackrabbit.oak.commons.PathUtils;

public class CommitBuilder {
    private Id baseRevId;
    private final String msg;
    private final RevisionStore store;
    private final StagedNodeTree stagedTree;
    private final List<Change> changeLog = new ArrayList<Change>();

    public CommitBuilder(Id baseRevId, String msg, RevisionStore store) throws Exception {
        this.baseRevId = baseRevId;
        this.msg = msg;
        this.store = store;
        this.stagedTree = new StagedNodeTree(store, baseRevId);
    }

    public void addNode(String parentNodePath, String nodeName, JsonObject node) throws Exception {
        AddNode change = new AddNode(parentNodePath, nodeName, node);
        ((Change)change).apply();
        this.changeLog.add(change);
    }

    public void removeNode(String nodePath) throws NotFoundException, Exception {
        RemoveNode change = new RemoveNode(nodePath);
        ((Change)change).apply();
        this.changeLog.add(change);
    }

    public void moveNode(String srcPath, String destPath) throws NotFoundException, Exception {
        MoveNode change = new MoveNode(srcPath, destPath);
        ((Change)change).apply();
        this.changeLog.add(change);
    }

    public void copyNode(String srcPath, String destPath) throws NotFoundException, Exception {
        CopyNode change = new CopyNode(srcPath, destPath);
        ((Change)change).apply();
        this.changeLog.add(change);
    }

    public void setProperty(String nodePath, String propName, String propValue) throws Exception {
        SetProperty change = new SetProperty(nodePath, propName, propValue);
        ((Change)change).apply();
        this.changeLog.add(change);
    }

    public Id doCommit() throws Exception {
        return this.doCommit(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Id doCommit(boolean createBranch) throws Exception {
        Id newRevId;
        Id rootNodeId;
        Id currentHead;
        boolean privateCommit;
        if (this.stagedTree.isEmpty() && !createBranch) {
            return this.baseRevId;
        }
        StoredCommit baseCommit = this.store.getCommit(this.baseRevId);
        if (createBranch && baseCommit.getBranchRootId() != null) {
            throw new Exception("cannot branch off a private branch");
        }
        boolean bl = privateCommit = createBranch || baseCommit.getBranchRootId() != null;
        if (!privateCommit && !(currentHead = this.store.getHeadCommitId()).equals(this.baseRevId)) {
            this.baseRevId = currentHead;
            this.stagedTree.reset(this.baseRevId);
            for (Change change : this.changeLog) {
                change.apply();
            }
        }
        RevisionStore.PutToken token = this.store.createPutToken();
        Id id = rootNodeId = this.changeLog.isEmpty() ? baseCommit.getRootNodeId() : this.stagedTree.persist(token);
        if (!privateCommit) {
            this.store.lockHead();
            try {
                Id currentHead2 = this.store.getHeadCommitId();
                if (!currentHead2.equals(this.baseRevId)) {
                    rootNodeId = this.stagedTree.merge(this.store.getNode(rootNodeId), currentHead2, this.baseRevId, token);
                    this.baseRevId = currentHead2;
                }
                if (this.store.getCommit(currentHead2).getRootNodeId().equals(rootNodeId)) {
                    Id id2 = currentHead2;
                    return id2;
                }
                MutableCommit newCommit = new MutableCommit();
                newCommit.setParentId(this.baseRevId);
                newCommit.setCommitTS(System.currentTimeMillis());
                newCommit.setMsg(this.msg);
                StringBuilder diff = new StringBuilder();
                for (Change change : this.changeLog) {
                    if (diff.length() > 0) {
                        diff.append('\n');
                    }
                    diff.append(change.asDiff());
                }
                newCommit.setChanges(diff.toString());
                newCommit.setRootNodeId(rootNodeId);
                newCommit.setBranchRootId(null);
                newRevId = this.store.putHeadCommit(token, newCommit, null);
            }
            finally {
                this.store.unlockHead();
            }
        } else {
            MutableCommit newCommit = new MutableCommit();
            newCommit.setParentId(baseCommit.getId());
            newCommit.setCommitTS(System.currentTimeMillis());
            newCommit.setMsg(this.msg);
            StringBuilder diff = new StringBuilder();
            for (Change change : this.changeLog) {
                if (diff.length() > 0) {
                    diff.append('\n');
                }
                diff.append(change.asDiff());
            }
            newCommit.setChanges(diff.toString());
            newCommit.setRootNodeId(rootNodeId);
            if (createBranch) {
                newCommit.setBranchRootId(baseCommit.getId());
            } else {
                newCommit.setBranchRootId(baseCommit.getBranchRootId());
            }
            newRevId = this.store.putCommit(token, newCommit);
        }
        this.stagedTree.reset(newRevId);
        this.changeLog.clear();
        return newRevId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Id doMerge() throws Exception {
        Id newRevId;
        StoredCommit branchCommit = this.store.getCommit(this.baseRevId);
        Id branchRootId = branchCommit.getBranchRootId();
        if (branchRootId == null) {
            throw new Exception("can only merge a private branch commit");
        }
        RevisionStore.PutToken token = this.store.createPutToken();
        Id rootNodeId = this.changeLog.isEmpty() ? branchCommit.getRootNodeId() : this.stagedTree.persist(token);
        this.store.lockHead();
        try {
            Id currentHead = this.store.getHeadCommitId();
            StoredNode ourRoot = this.store.getNode(rootNodeId);
            rootNodeId = this.stagedTree.merge(ourRoot, currentHead, branchRootId, token);
            if (this.store.getCommit(currentHead).getRootNodeId().equals(rootNodeId)) {
                Id id = currentHead;
                return id;
            }
            MutableCommit newCommit = new MutableCommit();
            newCommit.setParentId(currentHead);
            newCommit.setCommitTS(System.currentTimeMillis());
            newCommit.setMsg(this.msg);
            String diff = new DiffBuilder(this.store.getNodeState(this.store.getRootNode(currentHead)), this.store.getNodeState(this.store.getNode(rootNodeId)), "/", -1, this.store, "").build();
            newCommit.setChanges(diff);
            newCommit.setRootNodeId(rootNodeId);
            newCommit.setBranchRootId(null);
            newRevId = this.store.putHeadCommit(token, newCommit, branchRootId);
        }
        finally {
            this.store.unlockHead();
        }
        this.stagedTree.reset(newRevId);
        this.changeLog.clear();
        return newRevId;
    }

    class SetProperty
    extends Change {
        String nodePath;
        String propName;
        String propValue;

        SetProperty(String nodePath, String propName, String propValue) {
            this.nodePath = nodePath;
            this.propName = propName;
            this.propValue = propValue;
        }

        @Override
        void apply() throws Exception {
            CommitBuilder.this.stagedTree.setProperty(this.nodePath, this.propName, this.propValue);
        }

        @Override
        String asDiff() {
            JsopBuilder diff = new JsopBuilder();
            diff.tag('^').key(PathUtils.concat((String)this.nodePath, (String)this.propName));
            if (this.propValue != null) {
                diff.encodedValue(this.propValue);
            } else {
                diff.value(null);
            }
            return diff.toString();
        }
    }

    class CopyNode
    extends Change {
        String srcPath;
        String destPath;

        CopyNode(String srcPath, String destPath) {
            this.srcPath = srcPath;
            this.destPath = destPath;
        }

        @Override
        void apply() throws Exception {
            CommitBuilder.this.stagedTree.copy(this.srcPath, this.destPath);
        }

        @Override
        String asDiff() {
            JsopBuilder diff = new JsopBuilder();
            diff.tag('*').key(this.srcPath).value(this.destPath);
            return diff.toString();
        }
    }

    class MoveNode
    extends Change {
        String srcPath;
        String destPath;

        MoveNode(String srcPath, String destPath) {
            this.srcPath = srcPath;
            this.destPath = destPath;
        }

        @Override
        void apply() throws Exception {
            CommitBuilder.this.stagedTree.move(this.srcPath, this.destPath);
        }

        @Override
        String asDiff() {
            JsopBuilder diff = new JsopBuilder();
            diff.tag('>').key(this.srcPath).value(this.destPath);
            return diff.toString();
        }
    }

    class RemoveNode
    extends Change {
        String nodePath;

        RemoveNode(String nodePath) {
            this.nodePath = nodePath;
        }

        @Override
        void apply() throws Exception {
            CommitBuilder.this.stagedTree.remove(this.nodePath);
        }

        @Override
        String asDiff() {
            JsopBuilder diff = new JsopBuilder();
            diff.tag('-').value(this.nodePath);
            return diff.toString();
        }
    }

    class AddNode
    extends Change {
        String parentNodePath;
        String nodeName;
        JsonObject node;

        AddNode(String parentNodePath, String nodeName, JsonObject node) {
            this.parentNodePath = parentNodePath;
            this.nodeName = nodeName;
            this.node = node;
        }

        @Override
        void apply() throws Exception {
            CommitBuilder.this.stagedTree.add(this.parentNodePath, this.nodeName, this.node);
        }

        @Override
        String asDiff() {
            JsopBuilder diff = new JsopBuilder();
            diff.tag('+').key(PathUtils.concat((String)this.parentNodePath, (String)this.nodeName));
            this.node.toJson(diff);
            return diff.toString();
        }
    }

    abstract class Change {
        Change() {
        }

        abstract void apply() throws Exception;

        abstract String asDiff();
    }
}

