/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.mk.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.jackrabbit.mk.model.ChildNode;
import org.apache.jackrabbit.mk.model.DiffBuilder;
import org.apache.jackrabbit.mk.model.Id;
import org.apache.jackrabbit.mk.model.MutableCommit;
import org.apache.jackrabbit.mk.model.MutableNode;
import org.apache.jackrabbit.mk.model.NodeDelta;
import org.apache.jackrabbit.mk.model.StoredCommit;
import org.apache.jackrabbit.mk.model.StoredNode;
import org.apache.jackrabbit.mk.store.NotFoundException;
import org.apache.jackrabbit.mk.store.RevisionStore;
import org.apache.jackrabbit.oak.commons.PathUtils;

public class CommitBuilder {
    private Id baseRevId;
    private final String msg;
    private final RevisionStore store;
    private final Map<String, MutableNode> staged = new HashMap<String, MutableNode>();
    private final List<Change> changeLog = new ArrayList<Change>();

    public CommitBuilder(Id baseRevId, String msg, RevisionStore store) throws Exception {
        this.baseRevId = baseRevId;
        this.msg = msg;
        this.store = store;
    }

    public void addNode(String parentNodePath, String nodeName, NodeTree node) throws Exception {
        AddNode change = new AddNode(parentNodePath, nodeName, node);
        ((Change)change).apply();
        this.changeLog.add(change);
    }

    public void removeNode(String nodePath) throws NotFoundException, Exception {
        RemoveNode change = new RemoveNode(nodePath);
        ((Change)change).apply();
        this.changeLog.add(change);
    }

    public void moveNode(String srcPath, String destPath) throws NotFoundException, Exception {
        MoveNode change = new MoveNode(srcPath, destPath);
        ((Change)change).apply();
        this.changeLog.add(change);
    }

    public void copyNode(String srcPath, String destPath) throws NotFoundException, Exception {
        CopyNode change = new CopyNode(srcPath, destPath);
        ((Change)change).apply();
        this.changeLog.add(change);
    }

    public void setProperty(String nodePath, String propName, String propValue) throws Exception {
        SetProperty change = new SetProperty(nodePath, propName, propValue);
        ((Change)change).apply();
        this.changeLog.add(change);
    }

    public Id doCommit() throws Exception {
        return this.doCommit(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Id doCommit(boolean createBranch) throws Exception {
        Id newRevId;
        Id rootNodeId;
        Id currentHead;
        boolean privateCommit;
        if (this.staged.isEmpty() && !createBranch) {
            return this.baseRevId;
        }
        StoredCommit baseCommit = this.store.getCommit(this.baseRevId);
        if (createBranch && baseCommit.getBranchRootId() != null) {
            throw new Exception("cannot branch off a private branch");
        }
        boolean bl = privateCommit = createBranch || baseCommit.getBranchRootId() != null;
        if (!privateCommit && !(currentHead = this.store.getHeadCommitId()).equals(this.baseRevId)) {
            this.baseRevId = currentHead;
            this.staged.clear();
            for (Change change : this.changeLog) {
                change.apply();
            }
        }
        RevisionStore.PutToken token = this.store.createPutToken();
        Id id = rootNodeId = this.changeLog.isEmpty() ? baseCommit.getRootNodeId() : this.persistStagedNodes(token);
        if (!privateCommit) {
            this.store.lockHead();
            try {
                Object baseRoot;
                Id currentHead2 = this.store.getHeadCommitId();
                if (!currentHead2.equals(this.baseRevId)) {
                    baseRoot = this.store.getRootNode(this.baseRevId);
                    StoredNode theirRoot = this.store.getRootNode(currentHead2);
                    StoredNode ourRoot = this.store.getNode(rootNodeId);
                    rootNodeId = this.mergeTree((StoredNode)baseRoot, ourRoot, theirRoot, token);
                    this.baseRevId = currentHead2;
                }
                if (this.store.getCommit(currentHead2).getRootNodeId().equals(rootNodeId)) {
                    baseRoot = currentHead2;
                    return baseRoot;
                }
                MutableCommit newCommit = new MutableCommit();
                newCommit.setParentId(this.baseRevId);
                newCommit.setCommitTS(System.currentTimeMillis());
                newCommit.setMsg(this.msg);
                StringBuilder diff = new StringBuilder();
                for (Change change : this.changeLog) {
                    if (diff.length() > 0) {
                        diff.append('\n');
                    }
                    diff.append(change.asDiff());
                }
                newCommit.setChanges(diff.toString());
                newCommit.setRootNodeId(rootNodeId);
                newCommit.setBranchRootId(null);
                newRevId = this.store.putHeadCommit(token, newCommit, null);
            }
            finally {
                this.store.unlockHead();
            }
        } else {
            MutableCommit newCommit = new MutableCommit();
            newCommit.setParentId(baseCommit.getId());
            newCommit.setCommitTS(System.currentTimeMillis());
            newCommit.setMsg(this.msg);
            StringBuilder diff = new StringBuilder();
            for (Change change : this.changeLog) {
                if (diff.length() > 0) {
                    diff.append('\n');
                }
                diff.append(change.asDiff());
            }
            newCommit.setChanges(diff.toString());
            newCommit.setRootNodeId(rootNodeId);
            if (createBranch) {
                newCommit.setBranchRootId(baseCommit.getId());
            } else {
                newCommit.setBranchRootId(baseCommit.getBranchRootId());
            }
            newRevId = this.store.putCommit(token, newCommit);
        }
        this.staged.clear();
        this.changeLog.clear();
        return newRevId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Id doMerge() throws Exception {
        Id newRevId;
        StoredCommit branchCommit = this.store.getCommit(this.baseRevId);
        Id branchRootId = branchCommit.getBranchRootId();
        if (branchRootId == null) {
            throw new Exception("can only merge a private branch commit");
        }
        RevisionStore.PutToken token = this.store.createPutToken();
        Id rootNodeId = this.changeLog.isEmpty() ? branchCommit.getRootNodeId() : this.persistStagedNodes(token);
        this.store.lockHead();
        try {
            Id currentHead = this.store.getHeadCommitId();
            StoredNode baseRoot = this.store.getRootNode(branchRootId);
            StoredNode theirRoot = this.store.getRootNode(currentHead);
            StoredNode ourRoot = this.store.getNode(rootNodeId);
            rootNodeId = this.mergeTree(baseRoot, ourRoot, theirRoot, token);
            if (this.store.getCommit(currentHead).getRootNodeId().equals(rootNodeId)) {
                Id id = currentHead;
                return id;
            }
            MutableCommit newCommit = new MutableCommit();
            newCommit.setParentId(currentHead);
            newCommit.setCommitTS(System.currentTimeMillis());
            newCommit.setMsg(this.msg);
            String diff = new DiffBuilder(this.store.getNodeState(theirRoot), this.store.getNodeState(this.store.getNode(rootNodeId)), "/", this.store, "").build();
            newCommit.setChanges(diff);
            newCommit.setRootNodeId(rootNodeId);
            newCommit.setBranchRootId(null);
            newRevId = this.store.putHeadCommit(token, newCommit, branchRootId);
        }
        finally {
            this.store.unlockHead();
        }
        this.staged.clear();
        this.changeLog.clear();
        return newRevId;
    }

    MutableNode getOrCreateStagedNode(String nodePath) throws Exception {
        MutableNode node = this.staged.get(nodePath);
        if (node == null) {
            MutableNode parent = this.staged.get("/");
            if (parent == null) {
                parent = new MutableNode(this.store.getRootNode(this.baseRevId), this.store, "/");
                this.staged.put("/", parent);
            }
            node = parent;
            int nth = PathUtils.getDepth((String)nodePath) - 1;
            for (String name : PathUtils.elements((String)nodePath)) {
                String path;
                if ((node = this.staged.get(path = PathUtils.getAncestorPath((String)nodePath, (int)nth--))) == null) {
                    ChildNode cne = parent.getChildNodeEntry(name);
                    if (cne == null) {
                        throw new NotFoundException(nodePath);
                    }
                    node = new MutableNode(this.store.getNode(cne.getId()), this.store, path);
                    this.staged.put(path, node);
                }
                parent = node;
            }
        }
        return node;
    }

    void moveStagedNodes(String srcPath, String destPath) throws Exception {
        MutableNode node = this.staged.get(srcPath);
        if (node != null) {
            this.staged.remove(srcPath);
            this.staged.put(destPath, node);
            Iterator<String> it = node.getChildNodeNames(0, -1);
            while (it.hasNext()) {
                String childName = it.next();
                this.moveStagedNodes(PathUtils.concat((String)srcPath, (String)childName), PathUtils.concat((String)destPath, (String)childName));
            }
        }
    }

    void copyStagedNodes(String srcPath, String destPath, String breakAtSrcPath) throws Exception {
        if (srcPath.equals(breakAtSrcPath)) {
            return;
        }
        MutableNode node = this.staged.get(srcPath);
        if (node != null) {
            this.staged.put(destPath, new MutableNode(node, this.store, destPath));
            Iterator<String> it = node.getChildNodeNames(0, -1);
            while (it.hasNext()) {
                String childName = it.next();
                this.copyStagedNodes(PathUtils.concat((String)srcPath, (String)childName), PathUtils.concat((String)destPath, (String)childName), breakAtSrcPath);
            }
        }
    }

    void removeStagedNodes(String nodePath) throws Exception {
        MutableNode node = this.staged.get(nodePath);
        if (node != null) {
            this.staged.remove(nodePath);
            Iterator<String> it = node.getChildNodeNames(0, -1);
            while (it.hasNext()) {
                String childName = it.next();
                this.removeStagedNodes(PathUtils.concat((String)nodePath, (String)childName));
            }
        }
    }

    Id persistStagedNodes(RevisionStore.PutToken token) throws Exception {
        ArrayList<String> orderedPaths = new ArrayList<String>(this.staged.keySet());
        Collections.sort(orderedPaths, new Comparator<String>(){

            @Override
            public int compare(String path1, String path2) {
                int result = this.getDepth(path2) - this.getDepth(path1);
                if (result != 0) {
                    return result;
                }
                return path2.compareTo(path1);
            }

            int getDepth(String path) {
                return PathUtils.getDepth((String)path);
            }
        });
        Id rootNodeId = null;
        for (String path : orderedPaths) {
            Id id = this.store.putNode(token, this.staged.get(path));
            if (PathUtils.denotesRoot((String)path)) {
                rootNodeId = id;
                continue;
            }
            this.staged.get(PathUtils.getParentPath((String)path)).add(new ChildNode(PathUtils.getName((String)path), id));
        }
        if (rootNodeId == null) {
            throw new Exception("internal error: inconsistent staging area content");
        }
        return rootNodeId;
    }

    Id mergeTree(StoredNode baseRoot, StoredNode ourRoot, StoredNode theirRoot, RevisionStore.PutToken token) throws Exception {
        this.staged.clear();
        this.mergeNode(baseRoot, ourRoot, theirRoot, "/");
        return this.persistStagedNodes(token);
    }

    void mergeNode(StoredNode baseNode, StoredNode ourNode, StoredNode theirNode, String path) throws Exception {
        NodeDelta theirChanges = new NodeDelta(this.store, this.store.getNodeState(baseNode), this.store.getNodeState(theirNode));
        NodeDelta ourChanges = new NodeDelta(this.store, this.store.getNodeState(baseNode), this.store.getNodeState(ourNode));
        MutableNode mergedNode = new MutableNode(theirNode, this.store, path);
        this.staged.put(path, mergedNode);
        mergedNode.getProperties().putAll(ourChanges.getAddedProperties());
        mergedNode.getProperties().putAll(ourChanges.getChangedProperties());
        for (String string : ourChanges.getRemovedProperties().keySet()) {
            mergedNode.getProperties().remove(string);
        }
        for (Map.Entry entry : ourChanges.getAddedChildNodes().entrySet()) {
            mergedNode.add(new ChildNode((String)entry.getKey(), (Id)entry.getValue()));
        }
        for (Map.Entry entry : ourChanges.getChangedChildNodes().entrySet()) {
            mergedNode.add(new ChildNode((String)entry.getKey(), (Id)entry.getValue()));
        }
        for (String string : ourChanges.getRemovedChildNodes().keySet()) {
            mergedNode.remove(string);
        }
        List<NodeDelta.Conflict> conflicts = theirChanges.listConflicts(ourChanges);
        for (NodeDelta.Conflict conflict : conflicts) {
            String conflictName = conflict.getName();
            String conflictPath = PathUtils.concat((String)path, (String)conflictName);
            switch (conflict.getType()) {
                case PROPERTY_VALUE_CONFLICT: {
                    throw new Exception("concurrent modification of property " + conflictPath + " with conflicting values: \"" + ourNode.getProperties().get(conflictName) + "\", \"" + theirNode.getProperties().get(conflictName));
                }
                case NODE_CONTENT_CONFLICT: {
                    if (ourChanges.getChangedChildNodes().containsKey(conflictName)) {
                        StoredNode baseChild = this.store.getNode(baseNode.getChildNodeEntry(conflictName).getId());
                        StoredNode ourChild = this.store.getNode(ourNode.getChildNodeEntry(conflictName).getId());
                        StoredNode theirChild = this.store.getNode(theirNode.getChildNodeEntry(conflictName).getId());
                        this.mergeNode(baseChild, ourChild, theirChild, PathUtils.concat((String)path, (String)conflictName));
                        break;
                    }
                    throw new Exception("colliding concurrent node creation: " + conflictPath);
                }
                case REMOVED_DIRTY_PROPERTY_CONFLICT: {
                    mergedNode.getProperties().remove(conflictName);
                    break;
                }
                case REMOVED_DIRTY_NODE_CONFLICT: {
                    mergedNode.remove(conflictName);
                }
            }
        }
    }

    class SetProperty
    extends Change {
        String nodePath;
        String propName;
        String propValue;

        SetProperty(String nodePath, String propName, String propValue) {
            this.nodePath = nodePath;
            this.propName = propName;
            this.propValue = propValue;
        }

        @Override
        void apply() throws Exception {
            MutableNode node = CommitBuilder.this.getOrCreateStagedNode(this.nodePath);
            Map<String, String> properties = node.getProperties();
            if (this.propValue == null) {
                properties.remove(this.propName);
            } else {
                properties.put(this.propName, this.propValue);
            }
        }

        @Override
        String asDiff() {
            StringBuffer diff = new StringBuffer("^");
            diff.append('\"').append(PathUtils.concat((String)this.nodePath, (String)this.propName)).append("\":").append(this.propValue);
            return diff.toString();
        }
    }

    class CopyNode
    extends Change {
        String srcPath;
        String destPath;

        CopyNode(String srcPath, String destPath) {
            this.srcPath = srcPath;
            this.destPath = destPath;
        }

        @Override
        void apply() throws Exception {
            String srcParentPath = PathUtils.getParentPath((String)this.srcPath);
            String srcNodeName = PathUtils.getName((String)this.srcPath);
            String destParentPath = PathUtils.getParentPath((String)this.destPath);
            String destNodeName = PathUtils.getName((String)this.destPath);
            MutableNode srcParent = CommitBuilder.this.getOrCreateStagedNode(srcParentPath);
            ChildNode srcCNE = srcParent.getChildNodeEntry(srcNodeName);
            if (srcCNE == null) {
                throw new NotFoundException(this.srcPath);
            }
            if (CommitBuilder.this.staged.containsKey(this.srcPath)) {
                CommitBuilder.this.copyStagedNodes(this.srcPath, this.destPath, this.destPath);
            }
            MutableNode destParent = CommitBuilder.this.getOrCreateStagedNode(destParentPath);
            destParent.add(new ChildNode(destNodeName, srcCNE.getId()));
        }

        @Override
        String asDiff() {
            StringBuffer diff = new StringBuffer("*");
            diff.append('\"').append(this.srcPath).append("\":\"").append(this.destPath).append('\"');
            return diff.toString();
        }
    }

    class MoveNode
    extends Change {
        String srcPath;
        String destPath;

        MoveNode(String srcPath, String destPath) {
            this.srcPath = srcPath;
            this.destPath = destPath;
        }

        @Override
        void apply() throws Exception {
            if (PathUtils.isAncestor((String)this.srcPath, (String)this.destPath)) {
                throw new Exception("target path cannot be descendant of source path: " + this.destPath);
            }
            String srcParentPath = PathUtils.getParentPath((String)this.srcPath);
            String srcNodeName = PathUtils.getName((String)this.srcPath);
            String destParentPath = PathUtils.getParentPath((String)this.destPath);
            String destNodeName = PathUtils.getName((String)this.destPath);
            MutableNode srcParent = CommitBuilder.this.getOrCreateStagedNode(srcParentPath);
            if (srcParentPath.equals(destParentPath)) {
                if (srcParent.getChildNodeEntry(destNodeName) != null) {
                    throw new Exception("node already exists at move destination path: " + this.destPath);
                }
                if (srcParent.rename(srcNodeName, destNodeName) == null) {
                    throw new NotFoundException(this.srcPath);
                }
            } else {
                ChildNode srcCNE = srcParent.remove(srcNodeName);
                if (srcCNE == null) {
                    throw new NotFoundException(this.srcPath);
                }
                MutableNode destParent = CommitBuilder.this.getOrCreateStagedNode(destParentPath);
                if (destParent.getChildNodeEntry(destNodeName) != null) {
                    throw new Exception("node already exists at move destination path: " + this.destPath);
                }
                destParent.add(new ChildNode(destNodeName, srcCNE.getId()));
            }
            CommitBuilder.this.moveStagedNodes(this.srcPath, this.destPath);
        }

        @Override
        String asDiff() {
            StringBuffer diff = new StringBuffer(">");
            diff.append('\"').append(this.srcPath).append("\":\"").append(this.destPath).append('\"');
            return diff.toString();
        }
    }

    class RemoveNode
    extends Change {
        String nodePath;

        RemoveNode(String nodePath) {
            this.nodePath = nodePath;
        }

        @Override
        void apply() throws Exception {
            String parentPath = PathUtils.getParentPath((String)this.nodePath);
            String nodeName = PathUtils.getName((String)this.nodePath);
            MutableNode parent = CommitBuilder.this.getOrCreateStagedNode(parentPath);
            if (parent.remove(nodeName) == null) {
                throw new NotFoundException(this.nodePath);
            }
            CommitBuilder.this.removeStagedNodes(this.nodePath);
        }

        @Override
        String asDiff() {
            StringBuffer diff = new StringBuffer("-");
            diff.append('\"').append(this.nodePath).append('\"');
            return diff.toString();
        }
    }

    class AddNode
    extends Change {
        String parentNodePath;
        String nodeName;
        NodeTree node;

        AddNode(String parentNodePath, String nodeName, NodeTree node) {
            this.parentNodePath = parentNodePath;
            this.nodeName = nodeName;
            this.node = node;
        }

        @Override
        void apply() throws Exception {
            this.recursiveAddNode(this.parentNodePath, this.nodeName, this.node);
        }

        @Override
        String asDiff() {
            StringBuffer diff = new StringBuffer("+");
            diff.append('\"').append(PathUtils.concat((String)this.parentNodePath, (String)this.nodeName)).append("\":");
            this.node.toJson(diff);
            return diff.toString();
        }

        private void recursiveAddNode(String parentPath, String name, NodeTree node) throws Exception {
            MutableNode modParent = CommitBuilder.this.getOrCreateStagedNode(parentPath);
            if (modParent.getChildNodeEntry(name) != null) {
                throw new Exception("there's already a child node with name '" + name + "'");
            }
            String newPath = PathUtils.concat((String)parentPath, (String)name);
            MutableNode newChild = new MutableNode(CommitBuilder.this.store, newPath);
            newChild.getProperties().putAll(node.props);
            modParent.add(new ChildNode(name, null));
            CommitBuilder.this.staged.put(newPath, newChild);
            for (String childName : node.nodes.keySet()) {
                this.recursiveAddNode(PathUtils.concat((String)parentPath, (String)name), childName, node.nodes.get(childName));
            }
        }
    }

    abstract class Change {
        Change() {
        }

        abstract void apply() throws Exception;

        abstract String asDiff();
    }

    public static class NodeTree {
        public Map<String, String> props = new HashMap<String, String>();
        public Map<String, NodeTree> nodes = new HashMap<String, NodeTree>();

        void toJson(StringBuffer buf) {
            NodeTree.toJson(buf, this);
        }

        private static void toJson(StringBuffer buf, NodeTree node) {
            buf.append('{');
            for (String name : node.props.keySet()) {
                if (buf.charAt(buf.length() - 1) != '{') {
                    buf.append(',');
                }
                buf.append('\"').append(name).append("\":").append(node.props.get(name));
            }
            for (String name : node.nodes.keySet()) {
                if (buf.charAt(buf.length() - 1) != '{') {
                    buf.append(',');
                }
                buf.append('\"').append(name).append("\":");
                NodeTree.toJson(buf, node.nodes.get(name));
            }
            buf.append('}');
        }
    }
}

