/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.mk.util;

import java.util.ArrayList;
import java.util.List;

public class NameFilter {
    public static final char WILDCARD = '*';
    public static final char EXCLUDE_PREFIX = '-';
    public static final char ESCAPE = '\\';
    private final List<String> inclPatterns = new ArrayList<String>();
    private final List<String> exclPatterns = new ArrayList<String>();
    private boolean containsWildcard = false;

    public NameFilter(String[] patterns) {
        for (String pattern : patterns) {
            if (pattern.isEmpty()) continue;
            if (pattern.charAt(0) == '-') {
                pattern = pattern.substring(1);
                this.exclPatterns.add(pattern);
            } else {
                this.inclPatterns.add(pattern);
            }
            if (this.containsWildcard) continue;
            this.containsWildcard = NameFilter.containsWildCard(pattern);
        }
    }

    public boolean matches(String name) {
        boolean matched = false;
        for (String pattern : this.inclPatterns) {
            if (!NameFilter.internalMatches(name, pattern, 0, 0)) continue;
            matched = true;
            break;
        }
        if (matched) {
            for (String pattern : this.exclPatterns) {
                if (!NameFilter.internalMatches(name, pattern, 0, 0)) continue;
                matched = false;
                break;
            }
        }
        return matched;
    }

    public boolean containsWildcard() {
        return this.containsWildcard;
    }

    public List<String> getExclusionPatterns() {
        return this.exclPatterns;
    }

    public List<String> getInclusionPatterns() {
        return this.inclPatterns;
    }

    private static boolean containsWildCard(String pattern) {
        int len = pattern.length();
        int pos = 0;
        while (pos < len) {
            if (pattern.charAt(pos) == '\\' && pos < len - 1 && pattern.charAt(pos + 1) == '*') {
                pos += 2;
                continue;
            }
            if (pattern.charAt(pos) == '*') {
                return true;
            }
            ++pos;
        }
        return false;
    }

    private static boolean internalMatches(String s, String pattern, int sOff, int pOff) {
        int pLen = pattern.length();
        int sLen = s.length();
        while (pOff < pLen) {
            if (sOff >= sLen && pattern.charAt(pOff) != '*') {
                return false;
            }
            if (pattern.charAt(pOff) == '*') {
                if (++pOff >= pLen) {
                    return true;
                }
                while (true) {
                    if (NameFilter.internalMatches(s, pattern, sOff, pOff)) {
                        return true;
                    }
                    if (sOff >= sLen) {
                        return false;
                    }
                    ++sOff;
                }
            }
            if (pOff < pLen && sOff < sLen) {
                if (pattern.charAt(pOff) == '\\') {
                    if (pOff < pLen - 1 && pattern.charAt(pOff + 1) == '*') {
                        ++pOff;
                    }
                    if (pOff == 0 && pLen > 1 && pattern.charAt(pOff + 1) == '-') {
                        ++pOff;
                    }
                }
                if (pattern.charAt(pOff) != s.charAt(sOff)) {
                    return false;
                }
            }
            ++pOff;
            ++sOff;
        }
        return sOff >= sLen;
    }
}

