/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.mk.util;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.jackrabbit.mk.api.MicroKernelException;

public class ExceptionFactory {
    private static final String POM = "META-INF/maven/org.apache.jackrabbit/microkernel/pom.properties";
    private static String version;

    public static MicroKernelException convert(Exception e) {
        if (e instanceof MicroKernelException) {
            return (MicroKernelException)e;
        }
        return new MicroKernelException(e.getMessage() + " " + ExceptionFactory.getVersion(), e);
    }

    public static MicroKernelException get(String s) {
        return new MicroKernelException(s + " " + ExceptionFactory.getVersion());
    }

    public static String getVersion() {
        if (version == null) {
            try {
                InputStream in = ExceptionFactory.class.getClassLoader().getResourceAsStream(POM);
                if (in == null) {
                    in = new FileInputStream("target/maven-archiver/pom.properties");
                }
                Properties prop = new Properties();
                prop.load(in);
                in.close();
                version = "[" + prop.getProperty("artifactId") + "-" + prop.getProperty("version") + "]";
            }
            catch (IOException e) {
                version = "";
            }
        }
        return version;
    }
}

